/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import java.io.File;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.restdocs.RestDocumentationContext;

public class RestDocumentation
implements TestRule {
    private final String outputDirectory;
    private RestDocumentationContext context;

    public RestDocumentation(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Class testClass = description.getTestClass();
                String methodName = description.getMethodName();
                RestDocumentation.this.context = new RestDocumentationContext(testClass, methodName, new File(RestDocumentation.this.outputDirectory));
                try {
                    base.evaluate();
                }
                finally {
                    RestDocumentation.this.context = null;
                }
            }
        };
    }

    public RestDocumentationContext beforeOperation() {
        this.context.getAndIncrementStepCount();
        return this.context;
    }
}

