/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.constraints;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.util.PropertyPlaceholderHelper;

public class ResourceBundleConstraintDescriptionResolver
implements ConstraintDescriptionResolver {
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    private final ResourceBundle defaultDescriptions = ResourceBundleConstraintDescriptionResolver.getBundle("DefaultConstraintDescriptions");
    private final ResourceBundle userDescriptions;

    public ResourceBundleConstraintDescriptionResolver() {
        this(ResourceBundleConstraintDescriptionResolver.getBundle("ConstraintDescriptions"));
    }

    public ResourceBundleConstraintDescriptionResolver(ResourceBundle resourceBundle) {
        this.userDescriptions = resourceBundle;
    }

    private static ResourceBundle getBundle(String name) {
        try {
            return ResourceBundle.getBundle(ResourceBundleConstraintDescriptionResolver.class.getPackage().getName() + "." + name, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    @Override
    public String resolveDescription(Constraint constraint) {
        String key = constraint.getName() + ".description";
        return this.propertyPlaceholderHelper.replacePlaceholders(this.getDescription(key), (PropertyPlaceholderHelper.PlaceholderResolver)new ConstraintPlaceholderResolver(constraint));
    }

    private String getDescription(String key) {
        try {
            if (this.userDescriptions != null) {
                return this.userDescriptions.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.defaultDescriptions.getString(key);
    }

    private static final class ConstraintPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Constraint constraint;

        private ConstraintPlaceholderResolver(Constraint constraint) {
            this.constraint = constraint;
        }

        public String resolvePlaceholder(String placeholderName) {
            Object replacement = this.constraint.getConfiguration().get(placeholderName);
            return replacement != null ? replacement.toString() : null;
        }
    }
}

