/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.curl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.curl.QueryStringParser;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class CurlRequestSnippet
extends TemplatedSnippet {
    private static final Set<HeaderFilter> HEADER_FILTERS;

    protected CurlRequestSnippet() {
        this(null);
    }

    protected CurlRequestSnippet(Map<String, Object> attributes) {
        super("curl-request", attributes);
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", this.getUrl(operation));
        model.put("options", this.getOptions(operation));
        return model;
    }

    private String getUrl(Operation operation) {
        return String.format("'%s'", operation.getRequest().getUri());
    }

    private String getOptions(Operation operation) {
        StringWriter command = new StringWriter();
        PrintWriter printer = new PrintWriter(command);
        this.writeIncludeHeadersInOutputOption(printer);
        this.writeUserOptionIfNecessary(operation.getRequest(), printer);
        this.writeHttpMethodIfNecessary(operation.getRequest(), printer);
        this.writeHeaders(operation.getRequest().getHeaders(), printer);
        this.writePartsIfNecessary(operation.getRequest(), printer);
        this.writeContent(operation.getRequest(), printer);
        return command.toString();
    }

    private void writeIncludeHeadersInOutputOption(PrintWriter writer) {
        writer.print("-i");
    }

    private void writeUserOptionIfNecessary(OperationRequest request, PrintWriter writer) {
        List headerValue = request.getHeaders().get((Object)"Authorization");
        if (BasicAuthHeaderFilter.isBasicAuthHeader(headerValue)) {
            String credentials = BasicAuthHeaderFilter.decodeBasicAuthHeader(headerValue);
            writer.print(String.format(" -u '%s'", credentials));
        }
    }

    private void writeHttpMethodIfNecessary(OperationRequest request, PrintWriter writer) {
        if (!HttpMethod.GET.equals((Object)request.getMethod())) {
            writer.print(String.format(" -X %s", request.getMethod()));
        }
    }

    private void writeHeaders(HttpHeaders headers, PrintWriter writer) {
        for (Map.Entry entry : headers.entrySet()) {
            if (!this.allowedHeader(entry)) continue;
            for (String header : (List)entry.getValue()) {
                writer.print(String.format(" -H '%s: %s'", entry.getKey(), header));
            }
        }
    }

    private boolean allowedHeader(Map.Entry<String, List<String>> header) {
        for (HeaderFilter headerFilter : HEADER_FILTERS) {
            if (headerFilter.allow(header.getKey(), header.getValue())) continue;
            return false;
        }
        return true;
    }

    private void writePartsIfNecessary(OperationRequest request, PrintWriter writer) {
        for (OperationRequestPart part : request.getParts()) {
            writer.printf(" -F '%s=", part.getName());
            if (!StringUtils.hasText((String)part.getSubmittedFileName())) {
                writer.append(part.getContentAsString());
            } else {
                writer.printf("@%s", part.getSubmittedFileName());
            }
            if (part.getHeaders().getContentType() != null) {
                writer.append(";type=").append(part.getHeaders().getContentType().toString());
            }
            writer.append("'");
        }
    }

    private void writeContent(OperationRequest request, PrintWriter writer) {
        String content = request.getContentAsString();
        if (StringUtils.hasText((String)content)) {
            writer.print(String.format(" -d '%s'", content));
        } else if (!request.getParts().isEmpty()) {
            for (Map.Entry entry : request.getParameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    writer.print(String.format(" -F '%s=%s'", entry.getKey(), value));
                }
            }
        } else if (this.isPutOrPost(request)) {
            this.writeContentUsingParameters(request, writer);
        }
    }

    private void writeContentUsingParameters(OperationRequest request, PrintWriter writer) {
        Parameters uniqueParameters = this.getUniqueParameters(request);
        String queryString = uniqueParameters.toQueryString();
        if (StringUtils.hasText((String)queryString)) {
            writer.print(String.format(" -d '%s'", queryString));
        }
    }

    private Parameters getUniqueParameters(OperationRequest request) {
        Parameters queryStringParameters = new QueryStringParser().parse(request.getUri());
        Parameters uniqueParameters = new Parameters();
        for (Map.Entry parameter : request.getParameters().entrySet()) {
            this.addIfUnique(parameter, queryStringParameters, uniqueParameters);
        }
        return uniqueParameters;
    }

    private void addIfUnique(Map.Entry<String, List<String>> parameter, Parameters queryStringParameters, Parameters uniqueParameters) {
        if (!queryStringParameters.containsKey(parameter.getKey())) {
            uniqueParameters.put(parameter.getKey(), parameter.getValue());
        } else {
            List<String> candidates = parameter.getValue();
            List existing = queryStringParameters.get(parameter.getKey());
            for (String candidate : candidates) {
                if (existing.contains(candidate)) continue;
                uniqueParameters.add(parameter.getKey(), candidate);
            }
        }
    }

    private boolean isPutOrPost(OperationRequest request) {
        return HttpMethod.PUT.equals((Object)request.getMethod()) || HttpMethod.POST.equals((Object)request.getMethod());
    }

    static {
        HashSet<HeaderFilter> headerFilters = new HashSet<HeaderFilter>();
        headerFilters.add(new NamedHeaderFilter("Host"));
        headerFilters.add(new NamedHeaderFilter("Content-Length"));
        headerFilters.add(new BasicAuthHeaderFilter());
        HEADER_FILTERS = Collections.unmodifiableSet(headerFilters);
    }

    private static final class NamedHeaderFilter
    implements HeaderFilter {
        private final String name;

        private NamedHeaderFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean allow(String name, List<String> value) {
            return !this.name.equalsIgnoreCase(name);
        }
    }

    private static final class BasicAuthHeaderFilter
    implements HeaderFilter {
        private BasicAuthHeaderFilter() {
        }

        @Override
        public boolean allow(String name, List<String> value) {
            return !"Authorization".equals(name) || !BasicAuthHeaderFilter.isBasicAuthHeader(value);
        }

        static boolean isBasicAuthHeader(List<String> value) {
            return value != null && !value.isEmpty() && value.get(0).startsWith("Basic ");
        }

        static String decodeBasicAuthHeader(List<String> value) {
            return new String(Base64Utils.decodeFromString((String)value.get(0).substring(6)));
        }
    }

    private static interface HeaderFilter {
        public boolean allow(String var1, List<String> var2);
    }
}

