/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.curl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.springframework.restdocs.operation.Parameters;

public class QueryStringParser {
    public Parameters parse(URI uri) {
        String query = uri.getRawQuery();
        if (query != null) {
            return this.parse(query);
        }
        return new Parameters();
    }

    private Parameters parse(String query) {
        Parameters parameters = new Parameters();
        try (Scanner scanner = new Scanner(query);){
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                this.processParameter(scanner.next(), parameters);
            }
        }
        return parameters;
    }

    private void processParameter(String parameter, Parameters parameters) {
        String[] components = parameter.split("=");
        if (components.length > 0 && components.length < 3) {
            if (components.length == 2) {
                String name = components[0];
                String value = components[1];
                parameters.add(this.decode(name), this.decode(value));
            } else {
                List values = parameters.get(components[0]);
                if (values == null) {
                    parameters.put(components[0], new LinkedList());
                }
            }
        } else {
            throw new IllegalArgumentException("The parameter '" + parameter + "' is malformed");
        }
    }

    private String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to URL encode " + encoded + " using UTF-8", ex);
        }
    }
}

