/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.headers;

import java.util.Arrays;
import java.util.Map;
import org.springframework.restdocs.headers.HeaderDescriptor;
import org.springframework.restdocs.headers.RequestHeadersSnippet;
import org.springframework.restdocs.headers.ResponseHeadersSnippet;
import org.springframework.restdocs.snippet.Snippet;

public abstract class HeaderDocumentation {
    private HeaderDocumentation() {
    }

    public static HeaderDescriptor headerWithName(String name) {
        return new HeaderDescriptor(name);
    }

    public static Snippet requestHeaders(HeaderDescriptor ... descriptors) {
        return new RequestHeadersSnippet(Arrays.asList(descriptors));
    }

    public static Snippet requestHeaders(Map<String, Object> attributes, HeaderDescriptor ... descriptors) {
        return new RequestHeadersSnippet(Arrays.asList(descriptors), attributes);
    }

    public static Snippet responseHeaders(HeaderDescriptor ... descriptors) {
        return new ResponseHeadersSnippet(Arrays.asList(descriptors));
    }

    public static Snippet responseHeaders(Map<String, Object> attributes, HeaderDescriptor ... descriptors) {
        return new ResponseHeadersSnippet(Arrays.asList(descriptors), attributes);
    }
}

