/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.hypermedia.AbstractJsonLinkExtractor;
import org.springframework.restdocs.hypermedia.Link;

class HalLinkExtractor
extends AbstractJsonLinkExtractor {
    static final MediaType HAL_MEDIA_TYPE = new MediaType("application", "hal+json");

    HalLinkExtractor() {
    }

    @Override
    public Map<String, List<Link>> extractLinks(Map<String, Object> json) {
        LinkedHashMap<String, List<Link>> extractedLinks = new LinkedHashMap<String, List<Link>>();
        Object possibleLinks = json.get("_links");
        if (possibleLinks instanceof Map) {
            Map links = (Map)possibleLinks;
            for (Map.Entry entry : links.entrySet()) {
                String rel = (String)entry.getKey();
                extractedLinks.put(rel, HalLinkExtractor.convertToLinks(entry.getValue(), rel));
            }
        }
        return extractedLinks;
    }

    private static List<Link> convertToLinks(Object object, String rel) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (object instanceof Collection) {
            Collection possibleLinkObjects = (Collection)object;
            for (Object possibleLinkObject : possibleLinkObjects) {
                HalLinkExtractor.maybeAddLink(HalLinkExtractor.maybeCreateLink(rel, possibleLinkObject), links);
            }
        } else {
            HalLinkExtractor.maybeAddLink(HalLinkExtractor.maybeCreateLink(rel, object), links);
        }
        return links;
    }

    private static Link maybeCreateLink(String rel, Object possibleLinkObject) {
        Object hrefObject;
        if (possibleLinkObject instanceof Map && (hrefObject = ((Map)possibleLinkObject).get("href")) instanceof String) {
            return new Link(rel, (String)hrefObject);
        }
        return null;
    }

    private static void maybeAddLink(Link possibleLink, List<Link> links) {
        if (possibleLink != null) {
            links.add(possibleLink);
        }
    }
}

