/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.util.Arrays;
import java.util.Map;
import org.springframework.restdocs.hypermedia.AtomLinkExtractor;
import org.springframework.restdocs.hypermedia.ContentTypeLinkExtractor;
import org.springframework.restdocs.hypermedia.HalLinkExtractor;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.hypermedia.LinksSnippet;
import org.springframework.restdocs.snippet.Snippet;

public abstract class HypermediaDocumentation {
    private HypermediaDocumentation() {
    }

    public static LinkDescriptor linkWithRel(String rel) {
        return new LinkDescriptor(rel);
    }

    public static Snippet links(LinkDescriptor ... descriptors) {
        return new LinksSnippet(new ContentTypeLinkExtractor(), Arrays.asList(descriptors));
    }

    public static Snippet links(Map<String, Object> attributes, LinkDescriptor ... descriptors) {
        return new LinksSnippet(new ContentTypeLinkExtractor(), Arrays.asList(descriptors), attributes);
    }

    public static Snippet links(LinkExtractor linkExtractor, LinkDescriptor ... descriptors) {
        return new LinksSnippet(linkExtractor, Arrays.asList(descriptors));
    }

    public static Snippet links(LinkExtractor linkExtractor, Map<String, Object> attributes, LinkDescriptor ... descriptors) {
        return new LinksSnippet(linkExtractor, Arrays.asList(descriptors), attributes);
    }

    public static LinkExtractor halLinks() {
        return new HalLinkExtractor();
    }

    public static LinkExtractor atomLinks() {
        return new AtomLinkExtractor();
    }
}

