/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.hypermedia.Link;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.snippet.ModelCreationException;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;

public class LinksSnippet
extends TemplatedSnippet {
    private final Map<String, LinkDescriptor> descriptorsByRel = new LinkedHashMap<String, LinkDescriptor>();
    private final LinkExtractor linkExtractor;

    protected LinksSnippet(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors) {
        this(linkExtractor, descriptors, null);
    }

    protected LinksSnippet(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors, Map<String, Object> attributes) {
        super("links", attributes);
        this.linkExtractor = linkExtractor;
        for (LinkDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getRel(), (String)"Link descriptors must have a rel");
            if (!descriptor.isIgnored()) {
                Assert.notNull((Object)descriptor.getDescription(), (String)("The descriptor for link '" + descriptor.getRel() + "' must either have a description or be" + " marked as " + "ignored"));
            }
            this.descriptorsByRel.put(descriptor.getRel(), descriptor);
        }
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        OperationResponse response = operation.getResponse();
        try {
            this.validate(this.linkExtractor.extractLinks(response));
        }
        catch (IOException ex) {
            throw new ModelCreationException(ex);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("links", this.createLinksModel());
        return model;
    }

    private void validate(Map<String, List<Link>> links) {
        Set<String> actualRels = links.keySet();
        HashSet<String> undocumentedRels = new HashSet<String>(actualRels);
        undocumentedRels.removeAll(this.descriptorsByRel.keySet());
        HashSet<String> requiredRels = new HashSet<String>();
        for (Map.Entry<String, LinkDescriptor> relAndDescriptor : this.descriptorsByRel.entrySet()) {
            if (relAndDescriptor.getValue().isOptional()) continue;
            requiredRels.add(relAndDescriptor.getKey());
        }
        HashSet missingRels = new HashSet(requiredRels);
        missingRels.removeAll(actualRels);
        if (!undocumentedRels.isEmpty() || !missingRels.isEmpty()) {
            String message = "";
            if (!undocumentedRels.isEmpty()) {
                message = message + "Links with the following relations were not documented: " + undocumentedRels;
            }
            if (!missingRels.isEmpty()) {
                if (message.length() > 0) {
                    message = message + ". ";
                }
                message = message + "Links with the following relations were not found in the response: " + missingRels;
            }
            throw new SnippetException(message);
        }
    }

    private List<Map<String, Object>> createLinksModel() {
        ArrayList<Map<String, Object>> model = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, LinkDescriptor> entry : this.descriptorsByRel.entrySet()) {
            LinkDescriptor descriptor = entry.getValue();
            if (descriptor.isIgnored()) continue;
            model.add(this.createModelForDescriptor(descriptor));
        }
        return model;
    }

    protected final Map<String, LinkDescriptor> getDescriptorsByRel() {
        return this.descriptorsByRel;
    }

    protected Map<String, Object> createModelForDescriptor(LinkDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("rel", descriptor.getRel());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }
}

