/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;

class HeaderRemovingOperationPreprocessor
implements OperationPreprocessor {
    private final OperationRequestFactory requestFactory = new OperationRequestFactory();
    private final OperationResponseFactory responseFactory = new OperationResponseFactory();
    private final Set<String> headersToRemove;

    HeaderRemovingOperationPreprocessor(String ... headersToRemove) {
        this.headersToRemove = new HashSet<String>(Arrays.asList(headersToRemove));
    }

    @Override
    public OperationResponse preprocess(OperationResponse response) {
        return this.responseFactory.createFrom(response, this.removeHeaders(response.getHeaders()));
    }

    @Override
    public OperationRequest preprocess(OperationRequest request) {
        return this.requestFactory.createFrom(request, this.removeHeaders(request.getHeaders()));
    }

    private HttpHeaders removeHeaders(HttpHeaders originalHeaders) {
        HttpHeaders processedHeaders = new HttpHeaders();
        processedHeaders.putAll((Map)originalHeaders);
        for (String headerToRemove : this.headersToRemove) {
            processedHeaders.remove((Object)headerToRemove);
        }
        return processedHeaders;
    }
}

