/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.templates.mustache;

import java.io.IOException;
import java.io.InputStreamReader;
import org.springframework.core.io.Resource;
import org.springframework.restdocs.mustache.Mustache;
import org.springframework.restdocs.templates.Template;
import org.springframework.restdocs.templates.TemplateEngine;
import org.springframework.restdocs.templates.TemplateResourceResolver;
import org.springframework.restdocs.templates.mustache.MustacheTemplate;

public class MustacheTemplateEngine
implements TemplateEngine {
    private final Mustache.Compiler compiler = Mustache.compiler().escapeHTML(false);
    private final TemplateResourceResolver templateResourceResolver;

    public MustacheTemplateEngine(TemplateResourceResolver templateResourceResolver) {
        this.templateResourceResolver = templateResourceResolver;
    }

    @Override
    public Template compileTemplate(String name) throws IOException {
        Resource templateResource = this.templateResourceResolver.resolveTemplateResource(name);
        return new MustacheTemplate(this.compiler.compile(new InputStreamReader(templateResource.getInputStream())));
    }
}

