/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.cli.CliOperationRequest;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.StringUtils;

public class CurlRequestSnippet
extends TemplatedSnippet {
    protected CurlRequestSnippet() {
        this(null);
    }

    protected CurlRequestSnippet(Map<String, Object> attributes) {
        super("curl-request", attributes);
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", this.getUrl(operation));
        model.put("options", this.getOptions(operation));
        return model;
    }

    private String getUrl(Operation operation) {
        OperationRequest request = operation.getRequest();
        if (!request.getParameters().isEmpty() && this.includeParametersInUri(request)) {
            return String.format("'%s?%s'", request.getUri(), request.getParameters().toQueryString());
        }
        return String.format("'%s'", request.getUri());
    }

    private boolean includeParametersInUri(OperationRequest request) {
        return request.getMethod() == HttpMethod.GET || request.getContent().length > 0;
    }

    private String getOptions(Operation operation) {
        StringWriter command = new StringWriter();
        PrintWriter printer = new PrintWriter(command);
        this.writeIncludeHeadersInOutputOption(printer);
        CliOperationRequest request = new CliOperationRequest(operation.getRequest());
        this.writeUserOptionIfNecessary(request, printer);
        this.writeHttpMethodIfNecessary(request, printer);
        this.writeHeaders(request, printer);
        this.writePartsIfNecessary(request, printer);
        this.writeContent(request, printer);
        return command.toString();
    }

    private void writeIncludeHeadersInOutputOption(PrintWriter writer) {
        writer.print("-i");
    }

    private void writeUserOptionIfNecessary(CliOperationRequest request, PrintWriter writer) {
        String credentials = request.getBasicAuthCredentials();
        if (credentials != null) {
            writer.print(String.format(" -u '%s'", credentials));
        }
    }

    private void writeHttpMethodIfNecessary(OperationRequest request, PrintWriter writer) {
        if (!HttpMethod.GET.equals((Object)request.getMethod())) {
            writer.print(String.format(" -X %s", request.getMethod()));
        }
    }

    private void writeHeaders(CliOperationRequest request, PrintWriter writer) {
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            for (String header : (List)entry.getValue()) {
                writer.print(String.format(" -H '%s: %s'", entry.getKey(), header));
            }
        }
    }

    private void writePartsIfNecessary(OperationRequest request, PrintWriter writer) {
        for (OperationRequestPart part : request.getParts()) {
            writer.printf(" -F '%s=", part.getName());
            if (!StringUtils.hasText((String)part.getSubmittedFileName())) {
                writer.append(part.getContentAsString());
            } else {
                writer.printf("@%s", part.getSubmittedFileName());
            }
            if (part.getHeaders().getContentType() != null) {
                writer.append(";type=").append(part.getHeaders().getContentType().toString());
            }
            writer.append("'");
        }
    }

    private void writeContent(CliOperationRequest request, PrintWriter writer) {
        String content = request.getContentAsString();
        if (StringUtils.hasText((String)content)) {
            writer.print(String.format(" -d '%s'", content));
        } else if (!request.getParts().isEmpty()) {
            for (Map.Entry entry : request.getParameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    writer.print(String.format(" -F '%s=%s'", entry.getKey(), value));
                }
            }
        } else if (request.isPutOrPost()) {
            this.writeContentUsingParameters(request, writer);
        }
    }

    private void writeContentUsingParameters(CliOperationRequest request, PrintWriter writer) {
        Parameters uniqueParameters = request.getUniqueParameters();
        String queryString = uniqueParameters.toQueryString();
        if (StringUtils.hasText((String)queryString)) {
            writer.print(String.format(" -d '%s'", queryString));
        }
    }
}

