/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.cli.CliOperationRequest;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.StringUtils;

public class HttpieRequestSnippet
extends TemplatedSnippet {
    protected HttpieRequestSnippet() {
        this(null);
    }

    protected HttpieRequestSnippet(Map<String, Object> attributes) {
        super("httpie-request", attributes);
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        CliOperationRequest request = new CliOperationRequest(operation.getRequest());
        model.put("echoContent", this.getContentStandardIn(request));
        model.put("options", this.getOptions(request));
        model.put("url", this.getUrl(request));
        model.put("requestItems", this.getRequestItems(request));
        return model;
    }

    private Object getContentStandardIn(CliOperationRequest request) {
        String content = request.getContentAsString();
        if (StringUtils.hasText((String)content)) {
            return String.format("echo '%s' | ", content);
        }
        return "";
    }

    private String getOptions(CliOperationRequest request) {
        StringWriter options = new StringWriter();
        PrintWriter printer = new PrintWriter(options);
        this.writeOptions(request, printer);
        this.writeUserOptionIfNecessary(request, printer);
        this.writeMethodIfNecessary(request, printer);
        return options.toString();
    }

    private String getUrl(CliOperationRequest request) {
        if (!request.getUniqueParameters().isEmpty() && this.includeParametersInUri(request)) {
            return String.format("'%s?%s'", request.getUri(), request.getParameters().toQueryString());
        }
        return String.format("'%s'", request.getUri());
    }

    private String getRequestItems(CliOperationRequest request) {
        StringWriter requestItems = new StringWriter();
        PrintWriter printer = new PrintWriter(requestItems);
        this.writeFormDataIfNecessary(request, printer);
        this.writeHeaders(request, printer);
        this.writeParametersIfNecessary(request, printer);
        return requestItems.toString();
    }

    private void writeOptions(CliOperationRequest request, PrintWriter writer) {
        if (!request.getParts().isEmpty() || !request.getUniqueParameters().isEmpty() && !this.includeParametersInUri(request)) {
            writer.print("--form ");
        }
    }

    private boolean includeParametersInUri(CliOperationRequest request) {
        return request.getMethod() == HttpMethod.GET || request.getContent().length > 0;
    }

    private void writeUserOptionIfNecessary(CliOperationRequest request, PrintWriter writer) {
        String credentials = request.getBasicAuthCredentials();
        if (credentials != null) {
            writer.print(String.format("--auth '%s' ", credentials));
        }
    }

    private void writeMethodIfNecessary(OperationRequest request, PrintWriter writer) {
        writer.print(String.format("%s", request.getMethod().name()));
    }

    private void writeFormDataIfNecessary(OperationRequest request, PrintWriter writer) {
        for (OperationRequestPart part : request.getParts()) {
            writer.printf(" \\%n  '%s'", part.getName());
            if (!StringUtils.hasText((String)part.getSubmittedFileName())) {
                writer.printf("@<(echo '%s')", part.getContentAsString());
                continue;
            }
            writer.printf("@'%s'", part.getSubmittedFileName());
        }
    }

    private void writeHeaders(OperationRequest request, PrintWriter writer) {
        HttpHeaders headers = request.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            for (String header : (List)entry.getValue()) {
                if (!request.getParts().isEmpty() && ((String)entry.getKey()).equals("Content-Type") && header.startsWith("multipart/form-data")) continue;
                writer.print(String.format(" '%s:%s'", entry.getKey(), header));
            }
        }
    }

    private void writeParametersIfNecessary(CliOperationRequest request, PrintWriter writer) {
        if (StringUtils.hasText((String)request.getContentAsString())) {
            return;
        }
        if (!request.getParts().isEmpty()) {
            this.writeContentUsingParameters(request.getParameters(), writer);
        } else if (request.isPutOrPost()) {
            this.writeContentUsingParameters(request.getUniqueParameters(), writer);
        }
    }

    private void writeContentUsingParameters(Parameters parameters, PrintWriter writer) {
        for (Map.Entry entry : parameters.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                writer.append(String.format(" '%s='", entry.getKey()));
                continue;
            }
            for (String value : (List)entry.getValue()) {
                writer.append(String.format(" '%s=%s'", entry.getKey(), value));
            }
        }
    }
}

