/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.cli.CliDocumentation;
import org.springframework.restdocs.config.AbstractNestedConfigurer;
import org.springframework.restdocs.config.SnippetConfiguration;
import org.springframework.restdocs.http.HttpDocumentation;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.restdocs.templates.TemplateFormats;

public abstract class SnippetConfigurer<PARENT, TYPE>
extends AbstractNestedConfigurer<PARENT> {
    private List<Snippet> defaultSnippets = new ArrayList<Snippet>(Arrays.asList(CliDocumentation.curlRequest(), CliDocumentation.httpieRequest(), HttpDocumentation.httpRequest(), HttpDocumentation.httpResponse()));
    public static final String DEFAULT_SNIPPET_ENCODING = "UTF-8";
    public static final TemplateFormat DEFAULT_TEMPLATE_FORMAT = TemplateFormats.asciidoctor();
    private String snippetEncoding = "UTF-8";
    private TemplateFormat templateFormat = DEFAULT_TEMPLATE_FORMAT;

    protected SnippetConfigurer(PARENT parent) {
        super(parent);
    }

    @Override
    public void apply(Map<String, Object> configuration, RestDocumentationContext context) {
        configuration.put(SnippetConfiguration.class.getName(), new SnippetConfiguration(this.snippetEncoding, this.templateFormat));
        configuration.put("org.springframework.restdocs.defaultSnippets", this.defaultSnippets);
    }

    public TYPE withEncoding(String encoding) {
        this.snippetEncoding = encoding;
        return (TYPE)this;
    }

    public TYPE withDefaults(Snippet ... defaultSnippets) {
        this.defaultSnippets = new ArrayList<Snippet>(Arrays.asList(defaultSnippets));
        return (TYPE)this;
    }

    public TYPE withAdditionalDefaults(Snippet ... additionalDefaultSnippets) {
        this.defaultSnippets.addAll(Arrays.asList(additionalDefaultSnippets));
        return (TYPE)this;
    }

    public TYPE withTemplateFormat(TemplateFormat format) {
        this.templateFormat = format;
        return (TYPE)this;
    }
}

