/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.util.Map;
import org.springframework.http.HttpHeaders;

class HttpHeadersHelper {
    private final HttpHeaders httpHeaders;

    HttpHeadersHelper(HttpHeaders httpHeaders) {
        HttpHeaders headers = new HttpHeaders();
        if (httpHeaders != null) {
            headers.putAll((Map)httpHeaders);
        }
        this.httpHeaders = headers;
    }

    HttpHeadersHelper addIfAbsent(String name, String value) {
        if (this.httpHeaders.get((Object)name) == null) {
            this.httpHeaders.add(name, value);
        }
        return this;
    }

    HttpHeadersHelper updateContentLengthHeaderIfPresent(byte[] content) {
        if (this.httpHeaders.getContentLength() != -1L) {
            this.setContentLengthHeader(content);
        }
        return this;
    }

    HttpHeadersHelper setContentLengthHeader(byte[] content) {
        if (content == null || content.length == 0) {
            this.httpHeaders.remove((Object)"Content-Length");
        } else {
            this.httpHeaders.setContentLength((long)content.length);
        }
        return this;
    }

    HttpHeaders getHeaders() {
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.httpHeaders);
    }
}

