/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.operation.AbstractOperationMessage;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.Parameters;

class StandardOperationRequest
extends AbstractOperationMessage
implements OperationRequest {
    private HttpMethod method;
    private Parameters parameters;
    private Collection<OperationRequestPart> parts;
    private URI uri;

    StandardOperationRequest(URI uri, HttpMethod method, byte[] content, HttpHeaders headers, Parameters parameters, Collection<OperationRequestPart> parts) {
        super(content, headers);
        this.uri = uri;
        this.method = method;
        this.parameters = parameters;
        this.parts = parts;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Collection<OperationRequestPart> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }
}

