/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.ContentHandler;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.FieldTypeRequiredException;
import org.springframework.restdocs.payload.JsonContentHandler;
import org.springframework.restdocs.payload.XmlContentHandler;
import org.springframework.restdocs.snippet.ModelCreationException;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractFieldsSnippet
extends TemplatedSnippet {
    private final List<FieldDescriptor> fieldDescriptors;
    private final boolean ignoreUndocumentedFields;
    private final String type;

    @Deprecated
    protected AbstractFieldsSnippet(String type, List<FieldDescriptor> descriptors, Map<String, Object> attributes) {
        this(type, descriptors, attributes, false);
    }

    protected AbstractFieldsSnippet(String type, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields) {
        super(type + "-fields", attributes);
        for (FieldDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getPath(), (String)"Field descriptors must have a path");
            if (descriptor.isIgnored()) continue;
            Assert.notNull((Object)descriptor.getDescription(), (String)("The descriptor for field '" + descriptor.getPath() + "' must either have a description or" + " be marked as " + "ignored"));
        }
        this.fieldDescriptors = descriptors;
        this.ignoreUndocumentedFields = ignoreUndocumentedFields;
        this.type = type;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        ContentHandler contentHandler = this.getContentHandler(operation);
        this.validateFieldDocumentation(contentHandler);
        for (FieldDescriptor descriptor : this.fieldDescriptors) {
            try {
                descriptor.type(contentHandler.determineFieldType(descriptor));
            }
            catch (FieldDoesNotExistException ex) {
                String message = "Cannot determine the type of the field '" + descriptor.getPath() + "' as it is not present in the " + "payload. Please provide a type using " + "FieldDescriptor.type(Object type).";
                throw new FieldTypeRequiredException(message);
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        model.put("fields", fields);
        for (FieldDescriptor descriptor : this.fieldDescriptors) {
            if (descriptor.isIgnored()) continue;
            fields.add(this.createModelForDescriptor(descriptor));
        }
        return model;
    }

    private ContentHandler getContentHandler(Operation operation) {
        ContentHandler contentHandler;
        MediaType contentType = this.getContentType(operation);
        try {
            byte[] content = this.getContent(operation);
            if (content.length == 0) {
                throw new SnippetException("Cannot document " + this.type + " fields as the " + this.type + " body is empty");
            }
            contentHandler = contentType != null && MediaType.APPLICATION_XML.isCompatibleWith(contentType) ? new XmlContentHandler(content) : new JsonContentHandler(content);
        }
        catch (IOException ex) {
            throw new ModelCreationException(ex);
        }
        return contentHandler;
    }

    private void validateFieldDocumentation(ContentHandler payloadHandler) {
        String undocumentedPayload;
        List<FieldDescriptor> missingFields = payloadHandler.findMissingFields(this.fieldDescriptors);
        String string = undocumentedPayload = this.ignoreUndocumentedFields ? null : payloadHandler.getUndocumentedContent(this.fieldDescriptors);
        if (!missingFields.isEmpty() || StringUtils.hasText((String)undocumentedPayload)) {
            String message = "";
            if (StringUtils.hasText((String)undocumentedPayload)) {
                message = message + String.format("The following parts of the payload were not documented:%n%s", undocumentedPayload);
            }
            if (!missingFields.isEmpty()) {
                if (message.length() > 0) {
                    message = message + String.format("%n", new Object[0]);
                }
                ArrayList<String> paths = new ArrayList<String>();
                for (FieldDescriptor fieldDescriptor : missingFields) {
                    paths.add(fieldDescriptor.getPath());
                }
                message = message + "Fields with the following paths were not found in the payload: " + paths;
            }
            throw new SnippetException(message);
        }
    }

    protected abstract MediaType getContentType(Operation var1);

    protected abstract byte[] getContent(Operation var1) throws IOException;

    protected final List<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", descriptor.getPath());
        model.put("type", descriptor.getType().toString());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }
}

