/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.JsonFieldPath;

final class JsonFieldProcessor {
    JsonFieldProcessor() {
    }

    boolean hasField(JsonFieldPath fieldPath, Object payload) {
        final AtomicReference<Boolean> hasField = new AtomicReference<Boolean>(false);
        this.traverse(new ProcessingContext(payload, fieldPath), new MatchCallback(){

            @Override
            public void foundMatch(Match match) {
                hasField.set(true);
            }
        });
        return hasField.get();
    }

    Object extract(JsonFieldPath path, Object payload) {
        final ArrayList matches = new ArrayList();
        this.traverse(new ProcessingContext(payload, path), new MatchCallback(){

            @Override
            public void foundMatch(Match match) {
                matches.add(match.getValue());
            }
        });
        if (matches.isEmpty()) {
            throw new FieldDoesNotExistException(path);
        }
        if (path.isPrecise()) {
            return matches.get(0);
        }
        return matches;
    }

    void remove(JsonFieldPath path, Object payload) {
        this.traverse(new ProcessingContext(payload, path), new MatchCallback(){

            @Override
            public void foundMatch(Match match) {
                match.remove();
            }
        });
    }

    private void traverse(ProcessingContext context, MatchCallback matchCallback) {
        String segment = context.getSegment();
        if (JsonFieldPath.isArraySegment(segment)) {
            if (context.getPayload() instanceof List) {
                this.handleListPayload(context, matchCallback);
            }
        } else if (context.getPayload() instanceof Map && ((Map)context.getPayload()).containsKey(segment)) {
            this.handleMapPayload(context, matchCallback);
        }
    }

    private void handleListPayload(ProcessingContext context, MatchCallback matchCallback) {
        List list = (List)context.getPayload();
        Iterator items = list.iterator();
        if (context.isLeaf()) {
            while (items.hasNext()) {
                Object item = items.next();
                matchCallback.foundMatch(new ListMatch(items, list, item, context.getParentMatch()));
            }
        } else {
            while (items.hasNext()) {
                Object item = items.next();
                this.traverse(context.descend(item, new ListMatch(items, list, item, context.parent)), matchCallback);
            }
        }
    }

    private void handleMapPayload(ProcessingContext context, MatchCallback matchCallback) {
        Map map = (Map)context.getPayload();
        Object item = map.get(context.getSegment());
        MapMatch mapMatch = new MapMatch(item, map, context.getSegment(), context.getParentMatch());
        if (context.isLeaf()) {
            matchCallback.foundMatch(mapMatch);
        } else {
            this.traverse(context.descend(item, mapMatch), matchCallback);
        }
    }

    private static final class ProcessingContext {
        private final Object payload;
        private final List<String> segments;
        private final Match parent;
        private final JsonFieldPath path;

        private ProcessingContext(Object payload, JsonFieldPath path) {
            this(payload, path, null, null);
        }

        private ProcessingContext(Object payload, JsonFieldPath path, List<String> segments, Match parent) {
            this.payload = payload;
            this.path = path;
            this.segments = segments == null ? path.getSegments() : segments;
            this.parent = parent;
        }

        private String getSegment() {
            return this.segments.get(0);
        }

        private <T> T getPayload() {
            return (T)this.payload;
        }

        private boolean isLeaf() {
            return this.segments.size() == 1;
        }

        private Match getParentMatch() {
            return this.parent;
        }

        private ProcessingContext descend(Object payload, Match match) {
            return new ProcessingContext(payload, this.path, this.segments.subList(1, this.segments.size()), match);
        }
    }

    private static interface Match {
        public Object getValue();

        public void remove();
    }

    private static interface MatchCallback {
        public void foundMatch(Match var1);
    }

    private static final class ListMatch
    implements Match {
        private final Iterator<?> items;
        private final List<?> list;
        private final Object item;
        private final Match parent;

        private ListMatch(Iterator<?> items, List<?> list, Object item, Match parent) {
            this.items = items;
            this.list = list;
            this.item = item;
            this.parent = parent;
        }

        @Override
        public Object getValue() {
            return this.item;
        }

        @Override
        public void remove() {
            this.items.remove();
            if (this.list.isEmpty() && this.parent != null) {
                this.parent.remove();
            }
        }
    }

    private static final class MapMatch
    implements Match {
        private final Object item;
        private final Map<?, ?> map;
        private final String segment;
        private final Match parent;

        private MapMatch(Object item, Map<?, ?> map, String segment, Match parent) {
            this.item = item;
            this.map = map;
            this.segment = segment;
            this.parent = parent;
        }

        @Override
        public Object getValue() {
            return this.item;
        }

        @Override
        public void remove() {
            this.map.remove(this.segment);
            if (this.map.isEmpty() && this.parent != null) {
                this.parent.remove();
            }
        }
    }
}

