/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.AbstractFieldsSnippet;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;

public class RequestFieldsSnippet
extends AbstractFieldsSnippet {
    protected RequestFieldsSnippet(List<FieldDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected RequestFieldsSnippet(List<FieldDescriptor> descriptors, boolean ignoreUndocumentedFields) {
        this(descriptors, null, ignoreUndocumentedFields);
    }

    protected RequestFieldsSnippet(List<FieldDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected RequestFieldsSnippet(List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields) {
        super("request", descriptors, attributes, ignoreUndocumentedFields);
    }

    @Override
    protected MediaType getContentType(Operation operation) {
        return operation.getRequest().getHeaders().getContentType();
    }

    @Override
    protected byte[] getContent(Operation operation) throws IOException {
        return operation.getRequest().getContent();
    }

    public final RequestFieldsSnippet and(FieldDescriptor ... additionalDescriptors) {
        return this.andWithPrefix("", additionalDescriptors);
    }

    public final RequestFieldsSnippet and(List<FieldDescriptor> additionalDescriptors) {
        return this.andWithPrefix("", additionalDescriptors);
    }

    public final RequestFieldsSnippet andWithPrefix(String pathPrefix, FieldDescriptor ... additionalDescriptors) {
        ArrayList<FieldDescriptor> combinedDescriptors = new ArrayList<FieldDescriptor>();
        combinedDescriptors.addAll(this.getFieldDescriptors());
        combinedDescriptors.addAll(PayloadDocumentation.applyPathPrefix(pathPrefix, Arrays.asList(additionalDescriptors)));
        return new RequestFieldsSnippet(combinedDescriptors, this.getAttributes());
    }

    public final RequestFieldsSnippet andWithPrefix(String pathPrefix, List<FieldDescriptor> additionalDescriptors) {
        ArrayList<FieldDescriptor> combinedDescriptors = new ArrayList<FieldDescriptor>(this.getFieldDescriptors());
        combinedDescriptors.addAll(PayloadDocumentation.applyPathPrefix(pathPrefix, additionalDescriptors));
        return new RequestFieldsSnippet(combinedDescriptors, this.getAttributes());
    }
}

