/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.request.AbstractParametersSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.SnippetException;

public class RequestParametersSnippet
extends AbstractParametersSnippet {
    protected RequestParametersSnippet(List<ParameterDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected RequestParametersSnippet(List<ParameterDescriptor> descriptors, boolean ignoreUndocumentedParameters) {
        this(descriptors, null, ignoreUndocumentedParameters);
    }

    protected RequestParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected RequestParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedParameters) {
        super("request-parameters", descriptors, attributes, ignoreUndocumentedParameters);
    }

    @Override
    protected void verificationFailed(Set<String> undocumentedParameters, Set<String> missingParameters) {
        String message = "";
        if (!undocumentedParameters.isEmpty()) {
            message = message + "Request parameters with the following names were not documented: " + undocumentedParameters;
        }
        if (!missingParameters.isEmpty()) {
            if (message.length() > 0) {
                message = message + ". ";
            }
            message = message + "Request parameters with the following names were not found in the request: " + missingParameters;
        }
        throw new SnippetException(message);
    }

    @Override
    protected Set<String> extractActualParameters(Operation operation) {
        return operation.getRequest().getParameters().keySet();
    }

    public RequestParametersSnippet and(ParameterDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public RequestParametersSnippet and(List<ParameterDescriptor> additionalDescriptors) {
        ArrayList<ParameterDescriptor> combinedDescriptors = new ArrayList<ParameterDescriptor>(this.getParameterDescriptors().values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new RequestParametersSnippet(combinedDescriptors, this.getAttributes());
    }
}

