/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.generate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.generate.RestDocumentationGenerationException;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.ResponseConverter;
import org.springframework.restdocs.operation.StandardOperation;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.util.Assert;

public final class RestDocumentationGenerator<REQ, RESP> {
    public static final String ATTRIBUTE_NAME_URL_TEMPLATE = "org.springframework.restdocs.urlTemplate";
    public static final String ATTRIBUTE_NAME_DEFAULT_SNIPPETS = "org.springframework.restdocs.defaultSnippets";
    private final String identifier;
    private final OperationRequestPreprocessor requestPreprocessor;
    private final OperationResponsePreprocessor responsePreprocessor;
    private final List<Snippet> snippets;
    private final List<Snippet> additionalSnippets;
    private final RequestConverter<REQ> requestConverter;
    private final ResponseConverter<RESP> responseConverter;

    public RestDocumentationGenerator(String identifier, RequestConverter<REQ> requestConverter, ResponseConverter<RESP> responseConverter, Snippet ... snippets) {
        this(identifier, requestConverter, responseConverter, (OperationRequestPreprocessor)new IdentityOperationRequestPreprocessor(), new IdentityOperationResponsePreprocessor(), snippets);
    }

    public RestDocumentationGenerator(String identifier, RequestConverter<REQ> requestConverter, ResponseConverter<RESP> responseConverter, OperationRequestPreprocessor requestPreprocessor, Snippet ... snippets) {
        this(identifier, requestConverter, responseConverter, requestPreprocessor, new IdentityOperationResponsePreprocessor(), snippets);
    }

    public RestDocumentationGenerator(String identifier, RequestConverter<REQ> requestConverter, ResponseConverter<RESP> responseConverter, OperationResponsePreprocessor responsePreprocessor, Snippet ... snippets) {
        this(identifier, requestConverter, responseConverter, (OperationRequestPreprocessor)new IdentityOperationRequestPreprocessor(), responsePreprocessor, snippets);
    }

    public RestDocumentationGenerator(String identifier, RequestConverter<REQ> requestConverter, ResponseConverter<RESP> responseConverter, OperationRequestPreprocessor requestPreprocessor, OperationResponsePreprocessor responsePreprocessor, Snippet ... snippets) {
        Assert.notNull((Object)identifier, (String)"identifier must be non-null");
        Assert.notNull(requestConverter, (String)"requestConverter must be non-null");
        Assert.notNull(responseConverter, (String)"responseConverter must be non-null");
        Assert.notNull((Object)identifier, (String)"identifier must be non-null");
        Assert.notNull((Object)requestPreprocessor, (String)"requestPreprocessor must be non-null");
        Assert.notNull((Object)responsePreprocessor, (String)"responsePreprocessor must be non-null");
        Assert.notNull((Object)snippets, (String)"snippets must be non-null");
        this.identifier = identifier;
        this.requestConverter = requestConverter;
        this.responseConverter = responseConverter;
        this.requestPreprocessor = requestPreprocessor;
        this.responsePreprocessor = responsePreprocessor;
        this.snippets = new ArrayList<Snippet>(Arrays.asList(snippets));
        this.additionalSnippets = new ArrayList<Snippet>();
    }

    public void handle(REQ request, RESP response, Map<String, Object> configuration) {
        OperationRequest operationRequest = this.requestPreprocessor.preprocess(this.requestConverter.convert(request));
        OperationResponse operationResponse = this.responsePreprocessor.preprocess(this.responseConverter.convert(response));
        HashMap<String, Object> attributes = new HashMap<String, Object>(configuration);
        StandardOperation operation = new StandardOperation(this.identifier, operationRequest, operationResponse, attributes);
        try {
            for (Snippet snippet : this.getSnippets(attributes)) {
                snippet.document(operation);
            }
        }
        catch (IOException ex) {
            throw new RestDocumentationGenerationException(ex);
        }
    }

    @Deprecated
    public void addSnippets(Snippet ... snippets) {
        this.additionalSnippets.addAll(Arrays.asList(snippets));
    }

    public RestDocumentationGenerator<REQ, RESP> withSnippets(Snippet ... snippets) {
        return new RestDocumentationGenerator<REQ, RESP>(this.identifier, this.requestConverter, this.responseConverter, this.requestPreprocessor, this.responsePreprocessor, snippets);
    }

    private List<Snippet> getSnippets(Map<String, Object> configuration) {
        ArrayList<Snippet> combinedSnippets = new ArrayList<Snippet>(this.snippets);
        List defaultSnippets = (List)configuration.get(ATTRIBUTE_NAME_DEFAULT_SNIPPETS);
        if (defaultSnippets != null) {
            combinedSnippets.addAll(defaultSnippets);
        }
        combinedSnippets.addAll(this.additionalSnippets);
        this.additionalSnippets.clear();
        return combinedSnippets;
    }

    private static final class IdentityOperationResponsePreprocessor
    implements OperationResponsePreprocessor {
        private IdentityOperationResponsePreprocessor() {
        }

        @Override
        public OperationResponse preprocess(OperationResponse response) {
            return response;
        }
    }

    private static final class IdentityOperationRequestPreprocessor
    implements OperationRequestPreprocessor {
        private IdentityOperationRequestPreprocessor() {
        }

        @Override
        public OperationRequest preprocess(OperationRequest request) {
            return request;
        }
    }
}

