/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.Iterator;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.preprocess.HeaderFilter;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;

class HeaderRemovingOperationPreprocessor
implements OperationPreprocessor {
    private final OperationRequestFactory requestFactory = new OperationRequestFactory();
    private final OperationResponseFactory responseFactory = new OperationResponseFactory();
    private final HeaderFilter headerFilter;

    HeaderRemovingOperationPreprocessor(HeaderFilter headerFilter) {
        this.headerFilter = headerFilter;
    }

    @Override
    public OperationResponse preprocess(OperationResponse response) {
        return this.responseFactory.createFrom(response, this.removeHeaders(response.getHeaders()));
    }

    @Override
    public OperationRequest preprocess(OperationRequest request) {
        return this.requestFactory.createFrom(request, this.removeHeaders(request.getHeaders()));
    }

    private HttpHeaders removeHeaders(HttpHeaders originalHeaders) {
        HttpHeaders processedHeaders = new HttpHeaders();
        processedHeaders.putAll((Map)originalHeaders);
        Iterator headers = processedHeaders.keySet().iterator();
        while (headers.hasNext()) {
            if (!this.headerFilter.excludeHeader((String)headers.next())) continue;
            headers.remove();
        }
        return processedHeaders;
    }
}

