/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.payload.ContentHandler;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.FieldTypesDoNotMatchException;
import org.springframework.restdocs.payload.JsonFieldPath;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.JsonFieldType;
import org.springframework.restdocs.payload.JsonFieldTypeResolver;
import org.springframework.restdocs.payload.PayloadHandlingException;

class JsonContentHandler
implements ContentHandler {
    private final JsonFieldProcessor fieldProcessor = new JsonFieldProcessor();
    private final JsonFieldTypeResolver fieldTypeResolver = new JsonFieldTypeResolver();
    private final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final byte[] rawContent;

    JsonContentHandler(byte[] content) throws IOException {
        this.rawContent = content;
    }

    @Override
    public List<FieldDescriptor> findMissingFields(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<FieldDescriptor> missingFields = new ArrayList<FieldDescriptor>();
        Object payload = this.readContent();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (fieldDescriptor.isOptional() || this.fieldProcessor.hasField(JsonFieldPath.compile(fieldDescriptor.getPath()), payload)) continue;
            missingFields.add(fieldDescriptor);
        }
        return missingFields;
    }

    @Override
    public String getUndocumentedContent(List<FieldDescriptor> fieldDescriptors) {
        Object content = this.readContent();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            JsonFieldPath path = JsonFieldPath.compile(fieldDescriptor.getPath());
            this.fieldProcessor.remove(path, content);
        }
        if (!this.isEmpty(content)) {
            try {
                return this.objectMapper.writeValueAsString(content);
            }
            catch (JsonProcessingException ex) {
                throw new PayloadHandlingException(ex);
            }
        }
        return null;
    }

    private Object readContent() {
        try {
            return new ObjectMapper().readValue(this.rawContent, Object.class);
        }
        catch (IOException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    private boolean isEmpty(Object object) {
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return ((List)object).isEmpty();
    }

    @Override
    public Object determineFieldType(FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getType() == null) {
            return this.fieldTypeResolver.resolveFieldType(fieldDescriptor.getPath(), this.readContent());
        }
        if (!(fieldDescriptor.getType() instanceof JsonFieldType)) {
            return fieldDescriptor.getType();
        }
        JsonFieldType descriptorFieldType = (JsonFieldType)((Object)fieldDescriptor.getType());
        try {
            JsonFieldType actualFieldType = this.fieldTypeResolver.resolveFieldType(fieldDescriptor.getPath(), this.readContent());
            if (descriptorFieldType == JsonFieldType.VARIES || descriptorFieldType == actualFieldType) {
                return descriptorFieldType;
            }
            throw new FieldTypesDoNotMatchException(fieldDescriptor, (Object)actualFieldType);
        }
        catch (FieldDoesNotExistException ex) {
            return fieldDescriptor.getType();
        }
    }
}

