/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.regex.Pattern;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.preprocess.ContentModifier;
import org.springframework.restdocs.operation.preprocess.PatternReplacingContentModifier;

class LinkMaskingContentModifier
implements ContentModifier {
    private static final String DEFAULT_MASK = "...";
    private static final Pattern LINK_HREF = Pattern.compile("\"href\"\\s*:\\s*\"(.*?)\"", 32);
    private final ContentModifier contentModifier;

    LinkMaskingContentModifier() {
        this(DEFAULT_MASK);
    }

    LinkMaskingContentModifier(String mask) {
        this.contentModifier = new PatternReplacingContentModifier(LINK_HREF, mask);
    }

    @Override
    public byte[] modifyContent(byte[] originalContent, MediaType contentType) {
        return this.contentModifier.modifyContent(originalContent, contentType);
    }
}

