/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.preprocess.ContentModifier;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class PrettyPrintingContentModifier
implements ContentModifier {
    private static final List<PrettyPrinter> PRETTY_PRINTERS = Collections.unmodifiableList(Arrays.asList(new JsonPrettyPrinter(), new XmlPrettyPrinter()));

    @Override
    public byte[] modifyContent(byte[] originalContent, MediaType contentType) {
        if (originalContent.length > 0) {
            for (PrettyPrinter prettyPrinter : PRETTY_PRINTERS) {
                try {
                    return prettyPrinter.prettyPrint(originalContent);
                }
                catch (Exception exception) {
                }
            }
        }
        return originalContent;
    }

    private static final class JsonPrettyPrinter
    implements PrettyPrinter {
        private final ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);

        private JsonPrettyPrinter() {
        }

        @Override
        public byte[] prettyPrint(byte[] original) throws IOException {
            return this.objectMapper.writeValueAsBytes((Object)this.objectMapper.readTree(original));
        }
    }

    private static final class XmlPrettyPrinter
    implements PrettyPrinter {
        private XmlPrettyPrinter() {
        }

        @Override
        public byte[] prettyPrint(byte[] original) throws Exception {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("doctype-public", "yes");
            ByteArrayOutputStream transformed = new ByteArrayOutputStream();
            transformer.setErrorListener(new SilentErrorListener());
            transformer.transform(this.createSaxSource(original), new StreamResult(transformed));
            return transformed.toByteArray();
        }

        private SAXSource createSaxSource(byte[] original) throws ParserConfigurationException, SAXException {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setErrorHandler(new SilentErrorHandler());
            return new SAXSource(xmlReader, new InputSource(new ByteArrayInputStream(original)));
        }

        private static final class SilentErrorHandler
        implements ErrorHandler {
            private SilentErrorHandler() {
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
            }
        }

        private static final class SilentErrorListener
        implements ErrorListener {
            private SilentErrorListener() {
            }

            @Override
            public void warning(TransformerException exception) throws TransformerException {
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
            }
        }
    }

    private static interface PrettyPrinter {
        public byte[] prettyPrint(byte[] var1) throws Exception;
    }
}

