/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.preprocess.ContentModifier;
import org.springframework.restdocs.operation.preprocess.ContentModifyingOperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class UriModifyingOperationPreprocessor
implements OperationPreprocessor {
    private final UriModifyingContentModifier contentModifier = new UriModifyingContentModifier();
    private final OperationPreprocessor contentModifyingDelegate = new ContentModifyingOperationPreprocessor(this.contentModifier);
    private String scheme;
    private String host;
    private String port;

    public UriModifyingOperationPreprocessor scheme(String scheme) {
        this.scheme = scheme;
        this.contentModifier.setScheme(scheme);
        return this;
    }

    public UriModifyingOperationPreprocessor host(String host) {
        this.host = host;
        this.contentModifier.setHost(host);
        return this;
    }

    public UriModifyingOperationPreprocessor port(int port) {
        return this.port(Integer.toString(port));
    }

    public UriModifyingOperationPreprocessor removePort() {
        return this.port("");
    }

    private UriModifyingOperationPreprocessor port(String port) {
        this.port = port;
        this.contentModifier.setPort(port);
        return this;
    }

    @Override
    public OperationRequest preprocess(OperationRequest request) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)request.getUri());
        if (this.scheme != null) {
            uriBuilder.scheme(this.scheme);
        }
        if (this.host != null) {
            uriBuilder.host(this.host);
        }
        if (this.port != null) {
            if (StringUtils.hasText((String)this.port)) {
                uriBuilder.port(this.port);
            } else {
                uriBuilder.port(null);
            }
        }
        URI modifiedUri = uriBuilder.build(true).toUri();
        HttpHeaders modifiedHeaders = this.modify(request.getHeaders());
        modifiedHeaders.set("Host", modifiedUri.getHost() + (modifiedUri.getPort() != -1 ? ":" + modifiedUri.getPort() : ""));
        return this.contentModifyingDelegate.preprocess(new OperationRequestFactory().create(uriBuilder.build(true).toUri(), request.getMethod(), request.getContent(), modifiedHeaders, request.getParameters(), this.modify(request.getParts()), request.getCookies()));
    }

    @Override
    public OperationResponse preprocess(OperationResponse response) {
        return this.contentModifyingDelegate.preprocess(new OperationResponseFactory().create(response.getStatusCode(), this.modify(response.getHeaders()), response.getContent()));
    }

    private HttpHeaders modify(HttpHeaders headers) {
        HttpHeaders modified = new HttpHeaders();
        for (Map.Entry header : headers.entrySet()) {
            for (String value : (List)header.getValue()) {
                modified.add((String)header.getKey(), this.contentModifier.modify(value));
            }
        }
        return modified;
    }

    private Collection<OperationRequestPart> modify(Collection<OperationRequestPart> parts) {
        ArrayList<OperationRequestPart> modifiedParts = new ArrayList<OperationRequestPart>();
        OperationRequestPartFactory factory = new OperationRequestPartFactory();
        for (OperationRequestPart part : parts) {
            modifiedParts.add(factory.create(part.getName(), part.getSubmittedFileName(), this.contentModifier.modifyContent(part.getContent(), part.getHeaders().getContentType()), this.modify(part.getHeaders())));
        }
        return modifiedParts;
    }

    private static final class UriModifyingContentModifier
    implements ContentModifier {
        private static final Pattern SCHEME_HOST_PORT_PATTERN = Pattern.compile("(http[s]?)://([^/:#?]+)(:[0-9]+)?");
        private String scheme;
        private String host;
        private String port;

        private UriModifyingContentModifier() {
        }

        private void setScheme(String scheme) {
            this.scheme = scheme;
        }

        private void setHost(String host) {
            this.host = host;
        }

        private void setPort(String port) {
            this.port = port;
        }

        @Override
        public byte[] modifyContent(byte[] content, MediaType contentType) {
            String input = contentType != null && contentType.getCharset() != null ? new String(content, contentType.getCharset()) : new String(content);
            return this.modify(input).getBytes();
        }

        private String modify(String input) {
            List<String> replacements = Arrays.asList(this.scheme, this.host, StringUtils.hasText((String)this.port) ? ":" + this.port : this.port);
            int previous = 0;
            Matcher matcher = SCHEME_HOST_PORT_PATTERN.matcher(input);
            StringBuilder builder = new StringBuilder();
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    if (matcher.start(i) >= 0) {
                        builder.append(input.substring(previous, matcher.start(i)));
                    }
                    if (matcher.start(i) >= 0) {
                        previous = matcher.end(i);
                    }
                    builder.append(this.getReplacement(matcher.group(i), replacements.get(i - 1)));
                }
            }
            if (previous < input.length()) {
                builder.append(input.substring(previous));
            }
            return builder.toString();
        }

        private String getReplacement(String original, String candidate) {
            if (candidate != null) {
                return candidate;
            }
            if (original != null) {
                return original;
            }
            return "";
        }
    }
}

