/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.util.Map;
import org.springframework.restdocs.cli.CommandFormatter;
import org.springframework.restdocs.cli.ConcatenatingCommandFormatter;
import org.springframework.restdocs.cli.CurlRequestSnippet;
import org.springframework.restdocs.cli.HttpieRequestSnippet;
import org.springframework.restdocs.snippet.Snippet;

public abstract class CliDocumentation {
    static final CommandFormatter DEFAULT_COMMAND_FORMATTER = CliDocumentation.multiLineFormat();

    private CliDocumentation() {
    }

    public static Snippet curlRequest() {
        return CliDocumentation.curlRequest(DEFAULT_COMMAND_FORMATTER);
    }

    public static Snippet curlRequest(Map<String, Object> attributes) {
        return CliDocumentation.curlRequest(attributes, DEFAULT_COMMAND_FORMATTER);
    }

    public static Snippet curlRequest(CommandFormatter commandFormatter) {
        return CliDocumentation.curlRequest(null, commandFormatter);
    }

    public static Snippet curlRequest(Map<String, Object> attributes, CommandFormatter commandFormatter) {
        return new CurlRequestSnippet(attributes, commandFormatter);
    }

    public static Snippet httpieRequest() {
        return CliDocumentation.httpieRequest(DEFAULT_COMMAND_FORMATTER);
    }

    public static Snippet httpieRequest(Map<String, Object> attributes) {
        return CliDocumentation.httpieRequest(attributes, DEFAULT_COMMAND_FORMATTER);
    }

    public static Snippet httpieRequest(CommandFormatter commandFormatter) {
        return CliDocumentation.httpieRequest(null, commandFormatter);
    }

    public static Snippet httpieRequest(Map<String, Object> attributes, CommandFormatter commandFormatter) {
        return new HttpieRequestSnippet(attributes, commandFormatter);
    }

    public static CommandFormatter multiLineFormat() {
        return new ConcatenatingCommandFormatter(" \\%n    ");
    }

    public static CommandFormatter singleLineFormat() {
        return new ConcatenatingCommandFormatter(" ");
    }
}

