/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.request.RequestPartDescriptor;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;

public class RequestPartsSnippet
extends TemplatedSnippet {
    private final Map<String, RequestPartDescriptor> descriptorsByName = new LinkedHashMap<String, RequestPartDescriptor>();
    private final boolean ignoreUndocumentedParts;

    protected RequestPartsSnippet(List<RequestPartDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected RequestPartsSnippet(List<RequestPartDescriptor> descriptors, boolean ignoreUndocumentedParts) {
        this(descriptors, null, ignoreUndocumentedParts);
    }

    protected RequestPartsSnippet(List<RequestPartDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected RequestPartsSnippet(List<RequestPartDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedParts) {
        super("request-parts", attributes);
        for (RequestPartDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getName(), (String)"Request part descriptors must have a name");
            if (!descriptor.isIgnored()) {
                Assert.notNull((Object)descriptor.getDescription(), (String)("The descriptor for request part '" + descriptor.getName() + "' must either have a description or be marked as ignored"));
            }
            this.descriptorsByName.put(descriptor.getName(), descriptor);
        }
        this.ignoreUndocumentedParts = ignoreUndocumentedParts;
    }

    public final RequestPartsSnippet and(RequestPartDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public final RequestPartsSnippet and(List<RequestPartDescriptor> additionalDescriptors) {
        ArrayList<RequestPartDescriptor> combinedDescriptors = new ArrayList<RequestPartDescriptor>(this.descriptorsByName.values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new RequestPartsSnippet(combinedDescriptors, this.getAttributes());
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        this.verifyRequestPartDescriptors(operation);
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> requestParts = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, RequestPartDescriptor> entry : this.descriptorsByName.entrySet()) {
            RequestPartDescriptor descriptor = entry.getValue();
            if (descriptor.isIgnored()) continue;
            requestParts.add(this.createModelForDescriptor(descriptor));
        }
        model.put("requestParts", requestParts);
        return model;
    }

    private void verifyRequestPartDescriptors(Operation operation) {
        Set<String> undocumentedRequestParts;
        Set<String> actualRequestParts = this.extractActualRequestParts(operation);
        HashSet<String> expectedRequestParts = new HashSet<String>();
        for (Map.Entry<String, RequestPartDescriptor> entry : this.descriptorsByName.entrySet()) {
            if (entry.getValue().isOptional()) continue;
            expectedRequestParts.add(entry.getKey());
        }
        if (this.ignoreUndocumentedParts) {
            undocumentedRequestParts = Collections.emptySet();
        } else {
            undocumentedRequestParts = new HashSet<String>(actualRequestParts);
            undocumentedRequestParts.removeAll(this.descriptorsByName.keySet());
        }
        HashSet<String> missingRequestParts = new HashSet<String>(expectedRequestParts);
        missingRequestParts.removeAll(actualRequestParts);
        if (!undocumentedRequestParts.isEmpty() || !missingRequestParts.isEmpty()) {
            this.verificationFailed(undocumentedRequestParts, missingRequestParts);
        }
    }

    private Set<String> extractActualRequestParts(Operation operation) {
        HashSet<String> actualRequestParts = new HashSet<String>();
        for (OperationRequestPart requestPart : operation.getRequest().getParts()) {
            actualRequestParts.add(requestPart.getName());
        }
        return actualRequestParts;
    }

    private void verificationFailed(Set<String> undocumentedRequestParts, Set<String> missingRequestParts) {
        String message = "";
        if (!undocumentedRequestParts.isEmpty()) {
            message = message + "Request parts with the following names were not documented: " + undocumentedRequestParts;
        }
        if (!missingRequestParts.isEmpty()) {
            if (message.length() > 0) {
                message = message + ". ";
            }
            message = message + "Request parts with the following names were not found in the request: " + missingRequestParts;
        }
        throw new SnippetException(message);
    }

    private Map<String, Object> createModelForDescriptor(RequestPartDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", descriptor.getName());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }
}

