/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.payload.ContentHandler;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.FieldTypesDoNotMatchException;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.JsonFieldType;
import org.springframework.restdocs.payload.JsonFieldTypesDiscoverer;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.SubsectionDescriptor;

class JsonContentHandler
implements ContentHandler {
    private final JsonFieldProcessor fieldProcessor = new JsonFieldProcessor();
    private final JsonFieldTypesDiscoverer fieldTypesDiscoverer = new JsonFieldTypesDiscoverer();
    private final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final byte[] rawContent;
    private final Collection<FieldDescriptor> fieldDescriptors;

    JsonContentHandler(byte[] content, Collection<FieldDescriptor> fieldDescriptors) {
        this.rawContent = content;
        this.fieldDescriptors = fieldDescriptors;
        this.readContent();
    }

    @Override
    public List<FieldDescriptor> findMissingFields() {
        ArrayList<FieldDescriptor> missingFields = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (!this.isMissing(fieldDescriptor)) continue;
            missingFields.add(fieldDescriptor);
        }
        return missingFields;
    }

    boolean isMissing(FieldDescriptor descriptor) {
        Object payload = this.readContent();
        return !descriptor.isOptional() && !this.fieldProcessor.hasField(descriptor.getPath(), payload) && !this.isNestedBeneathMissingOptionalField(descriptor, payload);
    }

    private boolean isNestedBeneathMissingOptionalField(FieldDescriptor descriptor, Object payload) {
        ArrayList<FieldDescriptor> candidates = new ArrayList<FieldDescriptor>(this.fieldDescriptors);
        candidates.remove(descriptor);
        for (FieldDescriptor candidate : candidates) {
            if (!candidate.isOptional() || !descriptor.getPath().startsWith(candidate.getPath()) || !this.isMissing(candidate, payload)) continue;
            return true;
        }
        return false;
    }

    private boolean isMissing(FieldDescriptor candidate, Object payload) {
        if (!this.fieldProcessor.hasField(candidate.getPath(), payload)) {
            return true;
        }
        JsonFieldProcessor.ExtractedField extracted = this.fieldProcessor.extract(candidate.getPath(), payload);
        return extracted.getValue() == null || this.isEmptyCollection(extracted.getValue());
    }

    private boolean isEmptyCollection(Object value) {
        if (!(value instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)value;
        for (Object entry : collection) {
            if (this.isEmptyCollection(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getUndocumentedContent() {
        Object content = this.readContent();
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (this.describesSubsection(fieldDescriptor)) {
                this.fieldProcessor.removeSubsection(fieldDescriptor.getPath(), content);
                continue;
            }
            this.fieldProcessor.remove(fieldDescriptor.getPath(), content);
        }
        if (!this.isEmpty(content)) {
            try {
                return this.objectMapper.writeValueAsString(content);
            }
            catch (JsonProcessingException ex) {
                throw new PayloadHandlingException(ex);
            }
        }
        return null;
    }

    private boolean describesSubsection(FieldDescriptor fieldDescriptor) {
        return fieldDescriptor instanceof SubsectionDescriptor;
    }

    private Object readContent() {
        try {
            return new ObjectMapper().readValue(this.rawContent, Object.class);
        }
        catch (IOException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    private boolean isEmpty(Object object) {
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return ((List)object).isEmpty();
    }

    @Override
    public Object resolveFieldType(FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getType() == null) {
            return this.fieldTypesDiscoverer.discoverFieldTypes(fieldDescriptor.getPath(), this.readContent()).coalesce(fieldDescriptor.isOptional());
        }
        if (!(fieldDescriptor.getType() instanceof JsonFieldType)) {
            return fieldDescriptor.getType();
        }
        JsonFieldType descriptorFieldType = (JsonFieldType)((Object)fieldDescriptor.getType());
        try {
            JsonFieldType actualFieldType = this.fieldTypesDiscoverer.discoverFieldTypes(fieldDescriptor.getPath(), this.readContent()).coalesce(fieldDescriptor.isOptional());
            if (descriptorFieldType == JsonFieldType.VARIES || descriptorFieldType == actualFieldType || fieldDescriptor.isOptional() && actualFieldType == JsonFieldType.NULL || this.isNestedBeneathMissingOptionalField(fieldDescriptor, this.readContent()) && actualFieldType == JsonFieldType.VARIES) {
                return descriptorFieldType;
            }
            throw new FieldTypesDoNotMatchException(fieldDescriptor, (Object)actualFieldType);
        }
        catch (FieldDoesNotExistException ex) {
            return fieldDescriptor.getType();
        }
    }
}

