/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.cli.CliOperationRequest;
import org.springframework.restdocs.cli.CommandFormatter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CurlRequestSnippet
extends TemplatedSnippet {
    private final CommandFormatter commandFormatter;

    protected CurlRequestSnippet(CommandFormatter commandFormatter) {
        this(null, commandFormatter);
    }

    protected CurlRequestSnippet(Map<String, Object> attributes, CommandFormatter commandFormatter) {
        super("curl-request", attributes);
        Assert.notNull((Object)commandFormatter, (String)"Command formatter must not be null");
        this.commandFormatter = commandFormatter;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", this.getUrl(operation));
        model.put("options", this.getOptions(operation));
        return model;
    }

    private String getUrl(Operation operation) {
        OperationRequest request = operation.getRequest();
        return String.format("'%s'", request.getUri());
    }

    private String getOptions(Operation operation) {
        StringBuilder builder = new StringBuilder();
        this.writeIncludeHeadersInOutputOption(builder);
        CliOperationRequest request = new CliOperationRequest(operation.getRequest());
        this.writeUserOptionIfNecessary(request, builder);
        this.writeHttpMethod(request, builder);
        ArrayList<String> additionalLines = new ArrayList<String>();
        this.writeHeaders(request, additionalLines);
        this.writeCookies(request, additionalLines);
        this.writePartsIfNecessary(request, additionalLines);
        this.writeContent(request, additionalLines);
        builder.append(this.commandFormatter.format(additionalLines));
        return builder.toString();
    }

    private void writeCookies(CliOperationRequest request, List<String> lines) {
        if (!CollectionUtils.isEmpty(request.getCookies())) {
            StringBuilder cookiesBuilder = new StringBuilder();
            for (RequestCookie cookie : request.getCookies()) {
                if (cookiesBuilder.length() > 0) {
                    cookiesBuilder.append(";");
                }
                cookiesBuilder.append(String.format("%s=%s", cookie.getName(), cookie.getValue()));
            }
            lines.add(String.format("--cookie '%s'", cookiesBuilder.toString()));
        }
    }

    private void writeIncludeHeadersInOutputOption(StringBuilder builder) {
        builder.append("-i");
    }

    private void writeUserOptionIfNecessary(CliOperationRequest request, StringBuilder builder) {
        String credentials = request.getBasicAuthCredentials();
        if (credentials != null) {
            builder.append(String.format(" -u '%s'", credentials));
        }
    }

    private void writeHttpMethod(OperationRequest request, StringBuilder builder) {
        builder.append(String.format(" -X %s", request.getMethod()));
    }

    private void writeHeaders(CliOperationRequest request, List<String> lines) {
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            for (String header : (List)entry.getValue()) {
                if (StringUtils.hasText((String)request.getContentAsString()) && "Content-Type".equals(entry.getKey()) && MediaType.APPLICATION_FORM_URLENCODED.equals((Object)request.getHeaders().getContentType())) continue;
                lines.add(String.format("-H '%s: %s'", entry.getKey(), header));
            }
        }
    }

    private void writePartsIfNecessary(OperationRequest request, List<String> lines) {
        for (OperationRequestPart part : request.getParts()) {
            StringBuilder oneLine = new StringBuilder();
            oneLine.append(String.format("-F '%s=", part.getName()));
            if (!StringUtils.hasText((String)part.getSubmittedFileName())) {
                oneLine.append(part.getContentAsString());
            } else {
                oneLine.append(String.format("@%s", part.getSubmittedFileName()));
            }
            if (part.getHeaders().getContentType() != null) {
                oneLine.append(";type=");
                oneLine.append(part.getHeaders().getContentType().toString());
            }
            oneLine.append("'");
            lines.add(oneLine.toString());
        }
    }

    private void writeContent(CliOperationRequest request, List<String> lines) {
        String content = request.getContentAsString();
        if (StringUtils.hasText((String)content)) {
            lines.add(String.format("-d '%s'", content));
        }
    }
}

