/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cookies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.cookies.CookieDescriptor;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;

public abstract class AbstractCookiesSnippet
extends TemplatedSnippet {
    private final Map<String, CookieDescriptor> descriptorsByName = new LinkedHashMap<String, CookieDescriptor>();
    private final boolean ignoreUndocumentedCookies;

    protected AbstractCookiesSnippet(String type, List<CookieDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedCookies) {
        super(type + "-cookies", attributes);
        for (CookieDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getName(), (String)"Cookie descriptors must have a name");
            if (!descriptor.isIgnored()) {
                Assert.notNull((Object)descriptor.getDescription(), (String)("The descriptor for cookie '" + descriptor.getName() + "' must either have a description or be marked as ignored"));
            }
            this.descriptorsByName.put(descriptor.getName(), descriptor);
        }
        this.ignoreUndocumentedCookies = ignoreUndocumentedCookies;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        this.verifyCookieDescriptors(operation);
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> cookies = new ArrayList<Map<String, Object>>();
        for (CookieDescriptor descriptor : this.descriptorsByName.values()) {
            if (descriptor.isIgnored()) continue;
            cookies.add(this.createModelForDescriptor(descriptor));
        }
        model.put("cookies", cookies);
        return model;
    }

    private void verifyCookieDescriptors(Operation operation) {
        Set<String> undocumentedCookies;
        Set<String> actualCookies = this.extractActualCookies(operation);
        HashSet<String> expectedCookies = new HashSet<String>();
        for (Map.Entry<String, CookieDescriptor> entry : this.descriptorsByName.entrySet()) {
            if (entry.getValue().isOptional()) continue;
            expectedCookies.add(entry.getKey());
        }
        if (this.ignoreUndocumentedCookies) {
            undocumentedCookies = Collections.emptySet();
        } else {
            undocumentedCookies = new HashSet<String>(actualCookies);
            undocumentedCookies.removeAll(this.descriptorsByName.keySet());
        }
        HashSet<String> missingCookies = new HashSet<String>(expectedCookies);
        missingCookies.removeAll(actualCookies);
        if (!undocumentedCookies.isEmpty() || !missingCookies.isEmpty()) {
            this.verificationFailed(undocumentedCookies, missingCookies);
        }
    }

    protected abstract Set<String> extractActualCookies(Operation var1);

    protected abstract void verificationFailed(Set<String> var1, Set<String> var2);

    protected final Map<String, CookieDescriptor> getCookieDescriptors() {
        return this.descriptorsByName;
    }

    protected final boolean isIgnoreUndocumentedCookies() {
        return this.ignoreUndocumentedCookies;
    }

    protected Map<String, Object> createModelForDescriptor(CookieDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", descriptor.getName());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }
}

