/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.snippet.TemplatedSnippet;

public class HttpResponseSnippet
extends TemplatedSnippet {
    protected HttpResponseSnippet() {
        this(null);
    }

    protected HttpResponseSnippet(Map<String, Object> attributes) {
        super("http-response", attributes);
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        OperationResponse response = operation.getResponse();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("responseBody", this.responseBody(response));
        model.put("headers", this.headers(response));
        HttpStatusCode status = response.getStatus();
        model.put("statusCode", status.value());
        model.put("statusReason", status instanceof HttpStatus ? ((HttpStatus)status).getReasonPhrase() : "");
        return model;
    }

    private String responseBody(OperationResponse response) {
        String content = response.getContentAsString();
        return content.isEmpty() ? content : String.format("%n%s", content);
    }

    private List<Map<String, String>> headers(OperationResponse response) {
        ArrayList<Map<String, String>> headers = new ArrayList<Map<String, String>>();
        for (Map.Entry header : response.getHeaders().entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                headers.add(this.header((String)header.getKey(), value));
            }
        }
        return headers;
    }

    private Map<String, String> header(String name, String value) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("name", name);
        header.put("value", value);
        return header;
    }
}

