/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.util.Collection;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.restdocs.operation.HttpHeadersHelper;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.ResponseCookie;
import org.springframework.restdocs.operation.StandardOperationResponse;

public class OperationResponseFactory {
    public OperationResponse create(HttpStatusCode status, HttpHeaders headers, byte[] content) {
        return new StandardOperationResponse(status, this.augmentHeaders(headers, content), content, Collections.emptyList());
    }

    public OperationResponse create(HttpStatusCode status, HttpHeaders headers, byte[] content, Collection<ResponseCookie> cookies) {
        return new StandardOperationResponse(status, this.augmentHeaders(headers, content), content, cookies);
    }

    public OperationResponse createFrom(OperationResponse original, byte[] newContent) {
        return new StandardOperationResponse(original.getStatus(), this.getUpdatedHeaders(original.getHeaders(), newContent), newContent, original.getCookies());
    }

    public OperationResponse createFrom(OperationResponse original, HttpHeaders newHeaders) {
        return new StandardOperationResponse(original.getStatus(), newHeaders, original.getContent(), original.getCookies());
    }

    private HttpHeaders augmentHeaders(HttpHeaders originalHeaders, byte[] content) {
        return new HttpHeadersHelper(originalHeaders).setContentLengthHeader(content).getHeaders();
    }

    private HttpHeaders getUpdatedHeaders(HttpHeaders originalHeaders, byte[] updatedContent) {
        return new HttpHeadersHelper(originalHeaders).updateContentLengthHeaderIfPresent(updatedContent).getHeaders();
    }
}

