/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.util.Assert;

public class HeadersModifyingOperationPreprocessor
implements OperationPreprocessor {
    private final OperationRequestFactory requestFactory = new OperationRequestFactory();
    private final OperationResponseFactory responseFactory = new OperationResponseFactory();
    private final List<Modification> modifications = new ArrayList<Modification>();

    @Override
    public OperationRequest preprocess(OperationRequest request) {
        return this.requestFactory.createFrom(request, this.preprocess(request.getHeaders()));
    }

    @Override
    public OperationResponse preprocess(OperationResponse response) {
        return this.responseFactory.createFrom(response, this.preprocess(response.getHeaders()));
    }

    private HttpHeaders preprocess(HttpHeaders headers) {
        HttpHeaders modifiedHeaders = new HttpHeaders();
        modifiedHeaders.putAll((Map)headers);
        for (Modification modification : this.modifications) {
            modification.applyTo(modifiedHeaders);
        }
        return modifiedHeaders;
    }

    public HeadersModifyingOperationPreprocessor add(String name, String value) {
        this.modifications.add(new AddHeaderModification(name, value));
        return this;
    }

    public HeadersModifyingOperationPreprocessor set(String name, String ... values) {
        Assert.notEmpty((Object[])values, (String)"At least one value must be provided");
        this.modifications.add(new SetHeaderModification(name, Arrays.asList(values)));
        return this;
    }

    public HeadersModifyingOperationPreprocessor remove(String name) {
        this.modifications.add(new RemoveHeaderModification(name));
        return this;
    }

    public HeadersModifyingOperationPreprocessor remove(String name, String value) {
        this.modifications.add(new RemoveValueHeaderModification(name, value));
        return this;
    }

    public HeadersModifyingOperationPreprocessor removeMatching(String namePattern) {
        this.modifications.add(new RemoveHeadersByNamePatternModification(Pattern.compile(namePattern)));
        return this;
    }

    private static interface Modification {
        public void applyTo(HttpHeaders var1);
    }

    private static final class AddHeaderModification
    implements Modification {
        private final String name;
        private final String value;

        private AddHeaderModification(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void applyTo(HttpHeaders headers) {
            headers.add(this.name, this.value);
        }
    }

    private static final class SetHeaderModification
    implements Modification {
        private final String name;
        private final List<String> values;

        private SetHeaderModification(String name, List<String> values) {
            this.name = name;
            this.values = values;
        }

        @Override
        public void applyTo(HttpHeaders headers) {
            headers.put(this.name, this.values);
        }
    }

    private static final class RemoveHeaderModification
    implements Modification {
        private final String name;

        private RemoveHeaderModification(String name) {
            this.name = name;
        }

        @Override
        public void applyTo(HttpHeaders headers) {
            headers.remove((Object)this.name);
        }
    }

    private static final class RemoveValueHeaderModification
    implements Modification {
        private final String name;
        private final String value;

        private RemoveValueHeaderModification(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void applyTo(HttpHeaders headers) {
            List values = headers.get((Object)this.name);
            if (values != null) {
                values.remove(this.value);
                if (values.isEmpty()) {
                    headers.remove((Object)this.name);
                }
            }
        }
    }

    private static final class RemoveHeadersByNamePatternModification
    implements Modification {
        private final Pattern namePattern;

        private RemoveHeadersByNamePatternModification(Pattern namePattern) {
            this.namePattern = namePattern;
        }

        @Override
        public void applyTo(HttpHeaders headers) {
            headers.keySet().removeIf(name -> this.namePattern.matcher((CharSequence)name).matches());
        }
    }
}

