/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cookies;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.cookies.CookieDescriptor;
import org.springframework.restdocs.cookies.RequestCookiesSnippet;
import org.springframework.restdocs.cookies.ResponseCookiesSnippet;

public abstract class CookieDocumentation {
    private CookieDocumentation() {
    }

    public static CookieDescriptor cookieWithName(String name) {
        return new CookieDescriptor(name);
    }

    public static RequestCookiesSnippet requestCookies(CookieDescriptor ... descriptors) {
        return CookieDocumentation.requestCookies(Arrays.asList(descriptors));
    }

    public static RequestCookiesSnippet requestCookies(List<CookieDescriptor> descriptors) {
        return new RequestCookiesSnippet(descriptors);
    }

    public static RequestCookiesSnippet relaxedRequestCookies(CookieDescriptor ... descriptors) {
        return CookieDocumentation.relaxedRequestCookies(Arrays.asList(descriptors));
    }

    public static RequestCookiesSnippet relaxedRequestCookies(List<CookieDescriptor> descriptors) {
        return new RequestCookiesSnippet(descriptors, true);
    }

    public static RequestCookiesSnippet requestCookies(Map<String, Object> attributes, CookieDescriptor ... descriptors) {
        return CookieDocumentation.requestCookies(attributes, Arrays.asList(descriptors));
    }

    public static RequestCookiesSnippet requestCookies(Map<String, Object> attributes, List<CookieDescriptor> descriptors) {
        return new RequestCookiesSnippet(descriptors, attributes);
    }

    public static RequestCookiesSnippet relaxedRequestCookies(Map<String, Object> attributes, CookieDescriptor ... descriptors) {
        return CookieDocumentation.relaxedRequestCookies(attributes, Arrays.asList(descriptors));
    }

    public static RequestCookiesSnippet relaxedRequestCookies(Map<String, Object> attributes, List<CookieDescriptor> descriptors) {
        return new RequestCookiesSnippet(descriptors, attributes, true);
    }

    public static ResponseCookiesSnippet responseCookies(CookieDescriptor ... descriptors) {
        return CookieDocumentation.responseCookies(Arrays.asList(descriptors));
    }

    public static ResponseCookiesSnippet responseCookies(List<CookieDescriptor> descriptors) {
        return new ResponseCookiesSnippet(descriptors);
    }

    public static ResponseCookiesSnippet relaxedResponseCookies(CookieDescriptor ... descriptors) {
        return CookieDocumentation.relaxedResponseCookies(Arrays.asList(descriptors));
    }

    public static ResponseCookiesSnippet relaxedResponseCookies(List<CookieDescriptor> descriptors) {
        return new ResponseCookiesSnippet(descriptors, true);
    }

    public static ResponseCookiesSnippet responseCookies(Map<String, Object> attributes, CookieDescriptor ... descriptors) {
        return CookieDocumentation.responseCookies(attributes, Arrays.asList(descriptors));
    }

    public static ResponseCookiesSnippet responseCookies(Map<String, Object> attributes, List<CookieDescriptor> descriptors) {
        return new ResponseCookiesSnippet(descriptors, attributes);
    }

    public static ResponseCookiesSnippet relaxedResponseCookies(Map<String, Object> attributes, CookieDescriptor ... descriptors) {
        return CookieDocumentation.relaxedResponseCookies(attributes, Arrays.asList(descriptors));
    }

    public static ResponseCookiesSnippet relaxedResponseCookies(Map<String, Object> attributes, List<CookieDescriptor> descriptors) {
        return new ResponseCookiesSnippet(descriptors, attributes, true);
    }
}

