/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.StringUtils;

public class HttpRequestSnippet
extends TemplatedSnippet {
    private static final String MULTIPART_BOUNDARY = "6o2knFse3p53ty9dmcQvWAIx1zInP11uCfbm";

    protected HttpRequestSnippet() {
        this(null);
    }

    protected HttpRequestSnippet(Map<String, Object> attributes) {
        super("http-request", attributes);
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("method", operation.getRequest().getMethod());
        model.put("path", this.getPath(operation.getRequest()));
        model.put("headers", this.getHeaders(operation.getRequest()));
        model.put("requestBody", this.getRequestBody(operation.getRequest()));
        return model;
    }

    private String getPath(OperationRequest request) {
        Object path = request.getUri().getRawPath();
        String queryString = request.getUri().getRawQuery();
        if (StringUtils.hasText((String)queryString)) {
            path = (String)path + "?" + queryString;
        }
        return path;
    }

    private boolean includeParametersInUri(OperationRequest request) {
        HttpMethod method = request.getMethod();
        return method != HttpMethod.PUT && method != HttpMethod.POST && method != HttpMethod.PATCH || request.getContent().length > 0 && !MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(request.getHeaders().getContentType());
    }

    private List<Map<String, String>> getHeaders(OperationRequest request) {
        ArrayList<Map<String, String>> headers = new ArrayList<Map<String, String>>();
        for (Map.Entry header : request.getHeaders().entrySet()) {
            for (String value : (List)header.getValue()) {
                if ("Content-Type".equals(header.getKey()) && !request.getParts().isEmpty()) {
                    headers.add(this.header((String)header.getKey(), String.format("%s; boundary=%s", value, MULTIPART_BOUNDARY)));
                    continue;
                }
                headers.add(this.header((String)header.getKey(), value));
            }
        }
        for (RequestCookie cookie : request.getCookies()) {
            headers.add(this.header("Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue())));
        }
        if (this.requiresFormEncodingContentTypeHeader(request)) {
            headers.add(this.header("Content-Type", "application/x-www-form-urlencoded"));
        }
        return headers;
    }

    private String getRequestBody(OperationRequest request) {
        StringWriter httpRequest = new StringWriter();
        PrintWriter writer = new PrintWriter(httpRequest);
        String content = request.getContentAsString();
        if (StringUtils.hasText((String)content)) {
            writer.printf("%n%s", content);
        } else if (this.isPutOrPost(request) && !request.getParts().isEmpty()) {
            this.writeParts(request, writer);
        }
        return httpRequest.toString();
    }

    private boolean isPutOrPost(OperationRequest request) {
        return HttpMethod.PUT.equals((Object)request.getMethod()) || HttpMethod.POST.equals((Object)request.getMethod());
    }

    private void writeParts(OperationRequest request, PrintWriter writer) {
        writer.println();
        for (OperationRequestPart part : request.getParts()) {
            this.writePartBoundary(writer);
            this.writePart(part, writer);
            writer.println();
        }
        this.writeMultipartEnd(writer);
    }

    private void writePartBoundary(PrintWriter writer) {
        writer.printf("--%s%n", MULTIPART_BOUNDARY);
    }

    private void writePart(OperationRequestPart part, PrintWriter writer) {
        this.writePart(part.getName(), part.getContentAsString(), part.getSubmittedFileName(), part.getHeaders().getContentType(), writer);
    }

    private void writePart(String name, String value, String filename, MediaType contentType, PrintWriter writer) {
        writer.printf("Content-Disposition: form-data; name=%s", name);
        if (StringUtils.hasText((String)filename)) {
            writer.printf("; filename=%s", filename);
        }
        writer.printf("%n", new Object[0]);
        if (contentType != null) {
            writer.printf("Content-Type: %s%n", contentType);
        }
        writer.println();
        writer.print(value);
    }

    private void writeMultipartEnd(PrintWriter writer) {
        writer.printf("--%s--", MULTIPART_BOUNDARY);
    }

    private boolean requiresFormEncodingContentTypeHeader(OperationRequest request) {
        return request.getHeaders().get((Object)"Content-Type") == null && this.isPutOrPost(request) && !this.includeParametersInUri(request);
    }

    private Map<String, String> header(String name, String value) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("name", name);
        header.put("value", value);
        return header;
    }
}

