/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mustache;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.mustache.DefaultCollector;
import org.springframework.restdocs.mustache.Escapers;
import org.springframework.restdocs.mustache.MustacheException;
import org.springframework.restdocs.mustache.MustacheParseException;
import org.springframework.restdocs.mustache.Template;

public class Mustache {
    protected static final int TEXT = 0;
    protected static final int MATCHING_START = 1;
    protected static final int MATCHING_END = 2;
    protected static final int TAG = 3;
    protected static final char NO_CHAR = '\u0000';
    protected static final TemplateLoader FAILING_LOADER = new TemplateLoader(){

        @Override
        public Reader getTemplate(String name) {
            throw new UnsupportedOperationException("Template loading not configured");
        }
    };
    protected static final Formatter DEFAULT_FORMATTER = new Formatter(){

        @Override
        public String format(Object value) {
            return String.valueOf(value);
        }
    };

    public static Compiler compiler() {
        return new Compiler(false, false, null, false, false, false, DEFAULT_FORMATTER, Escapers.HTML, FAILING_LOADER, new DefaultCollector(), new Delims());
    }

    protected static Template compile(Reader source, Compiler compiler) {
        Accumulator accum = new Parser(compiler).parse(source);
        return new Template(Mustache.trim(accum.finish(), true), compiler);
    }

    private Mustache() {
    }

    protected static Template.Segment[] trim(Template.Segment[] segs, boolean top) {
        int ll = segs.length;
        for (int ii = 0; ii < ll; ++ii) {
            boolean nextBlank;
            Template.Segment seg = segs[ii];
            Template.Segment pseg = ii > 0 ? segs[ii - 1] : null;
            Template.Segment nseg = ii < ll - 1 ? segs[ii + 1] : null;
            StringSegment prev = pseg instanceof StringSegment ? (StringSegment)pseg : null;
            StringSegment next = nseg instanceof StringSegment ? (StringSegment)nseg : null;
            boolean prevBlank = pseg == null && top || prev != null && prev.trailsBlank();
            boolean bl = nextBlank = nseg == null && top || next != null && next.leadsBlank();
            if (seg instanceof BlockSegment) {
                BlockSegment block = (BlockSegment)seg;
                if (prevBlank && block.firstLeadsBlank()) {
                    if (pseg != null) {
                        segs[ii - 1] = prev.trimTrailBlank();
                    }
                    block.trimFirstBlank();
                }
                if (!nextBlank || !block.lastTrailsBlank()) continue;
                block.trimLastBlank();
                if (nseg == null) continue;
                segs[ii + 1] = next.trimLeadBlank();
                continue;
            }
            if (!(seg instanceof FauxSegment) || !prevBlank || !nextBlank) continue;
            if (pseg != null) {
                segs[ii - 1] = prev.trimTrailBlank();
            }
            if (nseg == null) continue;
            segs[ii + 1] = next.trimLeadBlank();
        }
        return segs;
    }

    protected static void restoreStartTag(StringBuilder text, Delims starts) {
        text.insert(0, starts.start1);
        if (starts.start2 != '\u0000') {
            text.insert(1, starts.start2);
        }
    }

    protected static boolean allowsWhitespace(char typeChar) {
        return typeChar == '=' || typeChar == '!';
    }

    protected static class FauxSegment
    extends Template.Segment {
        protected FauxSegment() {
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
        }

        @Override
        public void visit(Visitor visit) {
        }

        public String toString() {
            return "Faux";
        }
    }

    protected static class InvertedSegment
    extends BlockSegment {
        protected final Compiler _comp;

        public InvertedSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            super(name, segs, line);
            this._comp = compiler;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getSectionValue(ctx, this._name, this._line);
            Iterator<?> iter = this._comp.collector.toIterator(value);
            if (iter != null) {
                if (!iter.hasNext()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof InvertibleLambda) {
                try {
                    ((InvertibleLambda)value).executeInverse(tmpl.createFragment(this._segs, ctx), out);
                }
                catch (IOException ioe) {
                    throw new MustacheException(ioe);
                }
            } else if (this._comp.isFalsey(value)) {
                this.executeSegs(tmpl, ctx, out);
            }
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('^', this._name, into);
            for (Template.Segment seg : this._segs) {
                seg.decompile(delims, into);
            }
            delims.addTag('/', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitInvertedSection(this._name)) {
                for (Template.Segment seg : this._segs) {
                    seg.visit(visitor);
                }
            }
        }

        public String toString() {
            return "Inverted(" + this._name + ":" + this._line + "): " + Arrays.toString(this._segs);
        }
    }

    protected static class SectionSegment
    extends BlockSegment {
        protected final Compiler _comp;

        public SectionSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            super(name, segs, line);
            this._comp = compiler;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getSectionValue(ctx, this._name, this._line);
            Iterator<?> iter = this._comp.collector.toIterator(value);
            if (iter != null) {
                int index = 0;
                while (iter.hasNext()) {
                    Object elem = iter.next();
                    boolean onFirst = index == 0;
                    boolean onLast = !iter.hasNext();
                    this.executeSegs(tmpl, ctx.nest(elem, ++index, onFirst, onLast), out);
                }
            } else if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Lambda) {
                try {
                    ((Lambda)value).execute(tmpl.createFragment(this._segs, ctx), out);
                }
                catch (IOException ioe) {
                    throw new MustacheException(ioe);
                }
            } else if (!this._comp.isFalsey(value)) {
                this.executeSegs(tmpl, ctx.nest(value), out);
            }
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('#', this._name, into);
            for (Template.Segment seg : this._segs) {
                seg.decompile(delims, into);
            }
            delims.addTag('/', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitSection(this._name)) {
                for (Template.Segment seg : this._segs) {
                    seg.visit(visitor);
                }
            }
        }

        public String toString() {
            return "Section(" + this._name + ":" + this._line + "): " + Arrays.toString(this._segs);
        }
    }

    protected static abstract class BlockSegment
    extends NamedSegment {
        protected final Template.Segment[] _segs;

        public boolean firstLeadsBlank() {
            if (this._segs.length == 0 || !(this._segs[0] instanceof StringSegment)) {
                return false;
            }
            return ((StringSegment)this._segs[0]).leadsBlank();
        }

        public void trimFirstBlank() {
            this._segs[0] = ((StringSegment)this._segs[0]).trimLeadBlank();
        }

        public boolean lastTrailsBlank() {
            int lastIdx = this._segs.length - 1;
            if (this._segs.length == 0 || !(this._segs[lastIdx] instanceof StringSegment)) {
                return false;
            }
            return ((StringSegment)this._segs[lastIdx]).trailsBlank();
        }

        public void trimLastBlank() {
            int idx = this._segs.length - 1;
            this._segs[idx] = ((StringSegment)this._segs[idx]).trimTrailBlank();
        }

        protected BlockSegment(String name, Template.Segment[] segs, int line) {
            super(name, line);
            this._segs = Mustache.trim(segs, false);
        }

        protected void executeSegs(Template tmpl, Template.Context ctx, Writer out) {
            for (Template.Segment seg : this._segs) {
                seg.execute(tmpl, ctx, out);
            }
        }
    }

    protected static class VariableSegment
    extends NamedSegment {
        protected final Formatter _formatter;
        protected final Escaper _escaper;

        public VariableSegment(String name, int line, Formatter formatter, Escaper escaper) {
            super(name, line);
            this._formatter = formatter;
            this._escaper = escaper;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getValueOrDefault(ctx, this._name, this._line);
            if (value == null) {
                String msg = Template.isThisName(this._name) ? "Resolved '.' to null (which is disallowed), on line " + this._line : "No key, method or field with name '" + this._name + "' on line " + this._line;
                throw new MustacheException.Context(msg, this._name, this._line);
            }
            VariableSegment.write(out, this._escaper.escape(this._formatter.format(value)));
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag(' ', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            visitor.visitVariable(this._name);
        }

        public String toString() {
            return "Var(" + this._name + ":" + this._line + ")";
        }
    }

    protected static abstract class NamedSegment
    extends Template.Segment {
        protected final String _name;
        protected final int _line;

        protected NamedSegment(String name, int line) {
            this._name = name;
            this._line = line;
        }
    }

    protected static class IncludedTemplateSegment
    extends Template.Segment {
        protected final Compiler _comp;
        protected final String _name;
        private Template _template;

        public IncludedTemplateSegment(Compiler compiler, String name) {
            this._comp = compiler;
            this._name = name;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            this.getTemplate().executeSegs(ctx, out);
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('>', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitInclude(this._name)) {
                this.getTemplate().visit(visitor);
            }
        }

        protected Template getTemplate() {
            if (this._template == null) {
                this._template = this._comp.loadTemplate(this._name);
            }
            return this._template;
        }
    }

    protected static class StringSegment
    extends Template.Segment {
        protected final String _text;
        protected final int _leadBlank;
        protected final int _trailBlank;

        public StringSegment(String text, boolean first) {
            this(text, StringSegment.blankPos(text, true, first), StringSegment.blankPos(text, false, first));
        }

        public StringSegment(String text, int leadBlank, int trailBlank) {
            assert (leadBlank >= -1);
            assert (trailBlank >= -1);
            this._text = text;
            this._leadBlank = leadBlank;
            this._trailBlank = trailBlank;
        }

        public boolean leadsBlank() {
            return this._leadBlank != -1;
        }

        public boolean trailsBlank() {
            return this._trailBlank != -1;
        }

        public StringSegment trimLeadBlank() {
            if (this._leadBlank == -1) {
                return this;
            }
            int lpos = this._leadBlank + 1;
            int newTrail = this._trailBlank == -1 ? -1 : this._trailBlank - lpos;
            return new StringSegment(this._text.substring(lpos), -1, newTrail);
        }

        public StringSegment trimTrailBlank() {
            return this._trailBlank == -1 ? this : new StringSegment(this._text.substring(0, this._trailBlank), this._leadBlank, -1);
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            StringSegment.write(out, this._text);
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            into.append(this._text);
        }

        @Override
        public void visit(Visitor visitor) {
            visitor.visitText(this._text);
        }

        public String toString() {
            return "Text(" + this._text.replace("\r", "\\r").replace("\n", "\\n") + ")" + this._leadBlank + "/" + this._trailBlank;
        }

        private static int blankPos(String text, boolean leading, boolean first) {
            int dd;
            int len = text.length();
            int ll = leading ? len : -1;
            int n = dd = leading ? 1 : -1;
            for (int ii = leading ? 0 : len - 1; ii != ll; ii += dd) {
                char c = text.charAt(ii);
                if (c == '\n') {
                    return leading ? ii : ii + 1;
                }
                if (Character.isWhitespace(c)) continue;
                return -1;
            }
            return leading || !first ? -1 : 0;
        }
    }

    protected static class Accumulator {
        protected final Compiler _comp;
        protected final boolean _topLevel;
        protected final List<Template.Segment> _segs = new ArrayList<Template.Segment>();

        public Accumulator(Compiler compiler, boolean topLevel) {
            this._comp = compiler;
            this._topLevel = topLevel;
        }

        public void addTextSegment(StringBuilder text) {
            if (text.length() > 0) {
                this._segs.add(new StringSegment(text.toString(), this._segs.isEmpty() && this._topLevel));
                text.setLength(0);
            }
        }

        public Accumulator addTagSegment(StringBuilder accum, final int tagLine) {
            final Accumulator outer = this;
            String tag = accum.toString().trim();
            final String tag1 = tag.substring(1).trim();
            accum.setLength(0);
            switch (tag.charAt(0)) {
                case '#': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._comp, false){

                        @Override
                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Section missing close tag '" + tag1 + "'", tagLine);
                        }

                        @Override
                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            1.requireSameName(tag1, itag, line);
                            outer._segs.add(new SectionSegment(this._comp, itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '>': {
                    this._segs.add(new IncludedTemplateSegment(this._comp, tag1));
                    return this;
                }
                case '^': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._comp, false){

                        @Override
                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Inverted section missing close tag '" + tag1 + "'", tagLine);
                        }

                        @Override
                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            2.requireSameName(tag1, itag, line);
                            outer._segs.add(new InvertedSegment(this._comp, itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '/': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return this.addCloseSectionSegment(tag1, tagLine);
                }
                case '!': {
                    this._segs.add(new FauxSegment());
                    return this;
                }
                case '&': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    this._segs.add(new VariableSegment(tag1, tagLine, this._comp.formatter, Escapers.NONE));
                    return this;
                }
            }
            Accumulator.requireNoNewlines(tag, tagLine);
            this._segs.add(new VariableSegment(tag, tagLine, this._comp.formatter, this._comp.escaper));
            return this;
        }

        public void addFauxSegment() {
            this._segs.add(new FauxSegment());
        }

        public Template.Segment[] finish() {
            return this._segs.toArray(new Template.Segment[this._segs.size()]);
        }

        protected Accumulator addCloseSectionSegment(String tag, int line) {
            throw new MustacheParseException("Section close tag with no open tag '" + tag + "'", line);
        }

        protected static void requireNoNewlines(String tag, int line) {
            if (tag.indexOf(10) != -1 || tag.indexOf(13) != -1) {
                throw new MustacheParseException("Invalid tag name: contains newline '" + tag + "'", line);
            }
        }

        protected static void requireSameName(String name1, String name2, int line) {
            if (!name1.equals(name2)) {
                throw new MustacheParseException("Section close tag with mismatched open tag '" + name2 + "' != '" + name1 + "'", line);
            }
        }
    }

    protected static class Delims {
        public char start1 = (char)123;
        public char end1 = (char)125;
        public char start2 = (char)123;
        public char end2 = (char)125;

        protected Delims() {
        }

        public boolean isStaches() {
            return this.start1 == '{' && this.start2 == '{' && this.end1 == '}' && this.end2 == '}';
        }

        public Delims updateDelims(String dtext) {
            String[] delims = dtext.split(" ");
            if (delims.length != 2) {
                throw new MustacheException(Delims.errmsg(dtext));
            }
            switch (delims[0].length()) {
                case 1: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = '\u0000';
                    break;
                }
                case 2: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = delims[0].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(Delims.errmsg(dtext));
                }
            }
            switch (delims[1].length()) {
                case 1: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = '\u0000';
                    break;
                }
                case 2: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = delims[1].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(Delims.errmsg(dtext));
                }
            }
            return this;
        }

        public void addTag(char prefix, String name, StringBuilder into) {
            into.append(this.start1);
            into.append(this.start2);
            if (prefix != ' ') {
                into.append(prefix);
            }
            into.append(name);
            into.append(this.end1);
            into.append(this.end2);
        }

        Delims copy() {
            Delims d = new Delims();
            d.start1 = this.start1;
            d.start2 = this.start2;
            d.end1 = this.end1;
            d.end2 = this.end2;
            return d;
        }

        private static String errmsg(String dtext) {
            return "Invalid delimiter configuration '" + dtext + "'. Must be of the form {{=1 2=}} or {{=12 34=}} where 1, 2, 3 and 4 are delimiter chars.";
        }
    }

    protected static class Parser {
        final Delims delims;
        final StringBuilder text = new StringBuilder();
        Reader source;
        Accumulator accum;
        int state = 0;
        int line = 1;
        int column = 0;
        int tagStartColumn = -1;

        public Parser(Compiler compiler) {
            this.accum = new Accumulator(compiler, true);
            this.delims = compiler.delims.copy();
        }

        public Accumulator parse(Reader source) {
            int v;
            this.source = source;
            while ((v = this.nextChar()) != -1) {
                char c = (char)v;
                ++this.column;
                this.parseChar(c);
                if (c != '\n') continue;
                this.column = 0;
                ++this.line;
            }
            switch (this.state) {
                case 3: {
                    Mustache.restoreStartTag(this.text, this.delims);
                    break;
                }
                case 2: {
                    Mustache.restoreStartTag(this.text, this.delims);
                    this.text.append(this.delims.end1);
                    break;
                }
                case 1: {
                    this.text.append(this.delims.start1);
                    break;
                }
            }
            this.accum.addTextSegment(this.text);
            return this.accum;
        }

        protected void parseChar(char c) {
            switch (this.state) {
                case 0: {
                    if (c == this.delims.start1) {
                        this.state = 1;
                        this.tagStartColumn = this.column;
                        if (this.delims.start2 != '\u0000') break;
                        this.parseChar('\u0000');
                        break;
                    }
                    this.text.append(c);
                    break;
                }
                case 1: {
                    if (c == this.delims.start2) {
                        this.accum.addTextSegment(this.text);
                        this.state = 3;
                        break;
                    }
                    this.text.append(this.delims.start1);
                    this.state = 0;
                    this.parseChar(c);
                    break;
                }
                case 3: {
                    if (c == this.delims.end1) {
                        this.state = 2;
                        if (this.delims.end2 != '\u0000') break;
                        this.parseChar('\u0000');
                        break;
                    }
                    if (c == this.delims.start1 && this.text.length() > 0 && this.text.charAt(0) != '!') {
                        Mustache.restoreStartTag(this.text, this.delims);
                        this.accum.addTextSegment(this.text);
                        this.tagStartColumn = this.column;
                        if (this.delims.start2 == '\u0000') {
                            this.accum.addTextSegment(this.text);
                            this.state = 3;
                            break;
                        }
                        this.state = 1;
                        break;
                    }
                    this.text.append(c);
                    break;
                }
                case 2: {
                    if (c == this.delims.end2) {
                        if (this.text.charAt(0) == '=') {
                            this.delims.updateDelims(this.text.substring(1, this.text.length() - 1));
                            this.text.setLength(0);
                            this.accum.addFauxSegment();
                        } else {
                            if (this.delims.isStaches() && this.text.charAt(0) == this.delims.start1) {
                                int end3 = this.nextChar();
                                if (end3 != 125) {
                                    String got = end3 == -1 ? "" : String.valueOf((char)end3);
                                    throw new MustacheParseException("Invalid triple-mustache tag: {{" + this.text + "}}" + got, this.line);
                                }
                                this.text.replace(0, 1, "&");
                            }
                            this.accum = this.accum.addTagSegment(this.text, this.line);
                        }
                        this.state = 0;
                        break;
                    }
                    this.text.append(this.delims.end1);
                    this.state = 3;
                    this.parseChar(c);
                }
            }
        }

        protected int nextChar() {
            try {
                return this.source.read();
            }
            catch (IOException ioe) {
                throw new MustacheException(ioe);
            }
        }
    }

    public static interface Visitor {
        public void visitText(String var1);

        public void visitVariable(String var1);

        public boolean visitInclude(String var1);

        public boolean visitSection(String var1);

        public boolean visitInvertedSection(String var1);
    }

    public static interface CustomContext {
        public Object get(String var1) throws Exception;
    }

    public static interface Collector {
        public Iterator<?> toIterator(Object var1);

        public VariableFetcher createFetcher(Object var1, String var2);

        public <K, V> Map<K, V> createFetcherCache();
    }

    public static interface TemplateLoader {
        public Reader getTemplate(String var1) throws Exception;
    }

    public static interface Escaper {
        public String escape(String var1);
    }

    public static interface VariableFetcher {
        public Object get(Object var1, String var2) throws Exception;
    }

    public static interface InvertibleLambda
    extends Lambda {
        public void executeInverse(Template.Fragment var1, Writer var2) throws IOException;
    }

    public static interface Lambda {
        public void execute(Template.Fragment var1, Writer var2) throws IOException;
    }

    public static interface Formatter {
        public String format(Object var1);
    }

    public static class Compiler {
        public final boolean standardsMode;
        public final boolean strictSections;
        public final String nullValue;
        public final boolean missingIsNull;
        public final boolean emptyStringIsFalse;
        public final boolean zeroIsFalse;
        public final Formatter formatter;
        public final Escaper escaper;
        public final TemplateLoader loader;
        public final Collector collector;
        public final Delims delims;

        public Template compile(String template) {
            return this.compile(new StringReader(template));
        }

        public Template compile(Reader source) {
            return Mustache.compile(source, this);
        }

        public Compiler escapeHTML(boolean escapeHTML) {
            return this.withEscaper(escapeHTML ? Escapers.HTML : Escapers.NONE);
        }

        public Compiler standardsMode(boolean standardsMode) {
            return new Compiler(standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler strictSections(boolean strictSections) {
            return new Compiler(this.standardsMode, strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler defaultValue(String defaultValue) {
            return new Compiler(this.standardsMode, this.strictSections, defaultValue, true, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler nullValue(String nullValue) {
            return new Compiler(this.standardsMode, this.strictSections, nullValue, false, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler emptyStringIsFalse(boolean emptyStringIsFalse) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler zeroIsFalse(boolean zeroIsFalse) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler withFormatter(Formatter formatter) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler withEscaper(Escaper escaper) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, escaper, this.loader, this.collector, this.delims);
        }

        public Compiler withLoader(TemplateLoader loader) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, loader, this.collector, this.delims);
        }

        public Compiler withCollector(Collector collector) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, collector, this.delims);
        }

        public Compiler withDelims(String delims) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, new Delims().updateDelims(delims));
        }

        public String computeNullValue(String name) {
            return this.nullValue == null ? null : this.nullValue.replace("{{name}}", name);
        }

        public boolean isFalsey(Object value) {
            return this.emptyStringIsFalse && "".equals(this.formatter.format(value)) || this.zeroIsFalse && value instanceof Number && ((Number)value).longValue() == 0L;
        }

        public Template loadTemplate(String name) throws MustacheException {
            Reader tin = null;
            try {
                tin = this.loader.getTemplate(name);
                Template template = this.compile(tin);
                return template;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MustacheException("Unable to load template: " + name, e);
            }
            finally {
                if (tin != null) {
                    try {
                        tin.close();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }

        protected Compiler(boolean standardsMode, boolean strictSections, String nullValue, boolean missingIsNull, boolean emptyStringIsFalse, boolean zeroIsFalse, Formatter formatter, Escaper escaper, TemplateLoader loader, Collector collector, Delims delims) {
            this.standardsMode = standardsMode;
            this.strictSections = strictSections;
            this.nullValue = nullValue;
            this.missingIsNull = missingIsNull;
            this.emptyStringIsFalse = emptyStringIsFalse;
            this.zeroIsFalse = zeroIsFalse;
            this.formatter = formatter;
            this.escaper = escaper;
            this.loader = loader;
            this.collector = collector;
            this.delims = delims;
        }
    }
}

