/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.util.LinkedMultiValueMap;

public final class FormParameters
extends LinkedMultiValueMap<String, String> {
    private FormParameters() {
    }

    public static FormParameters from(OperationRequest request) {
        return FormParameters.of(request.getContentAsString());
    }

    private static FormParameters of(String bodyContent) {
        if (bodyContent == null || bodyContent.length() == 0) {
            return new FormParameters();
        }
        return FormParameters.parse(bodyContent);
    }

    private static FormParameters parse(String bodyContent) {
        FormParameters parameters = new FormParameters();
        try (Scanner scanner = new Scanner(bodyContent);){
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                FormParameters.processParameter(scanner.next(), parameters);
            }
        }
        return parameters;
    }

    private static void processParameter(String parameter, FormParameters parameters) {
        String[] components = parameter.split("=");
        if (components.length > 0 && components.length < 3) {
            if (components.length == 2) {
                String name = components[0];
                String value = components[1];
                parameters.add(FormParameters.decode(name), FormParameters.decode(value));
            } else {
                List values = (List)parameters.computeIfAbsent(components[0], p -> new LinkedList());
                values.add("");
            }
        } else {
            throw new IllegalArgumentException("The parameter '" + parameter + "' is malformed");
        }
    }

    private static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to URL decode " + encoded + " using UTF-8", ex);
        }
    }
}

