/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.util.LinkedMultiValueMap;

public final class QueryParameters
extends LinkedMultiValueMap<String, String> {
    private QueryParameters() {
    }

    public static QueryParameters from(OperationRequest request) {
        return QueryParameters.from(request.getUri().getRawQuery());
    }

    private static QueryParameters from(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return new QueryParameters();
        }
        return QueryParameters.parse(queryString);
    }

    private static QueryParameters parse(String query) {
        QueryParameters parameters = new QueryParameters();
        try (Scanner scanner = new Scanner(query);){
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                QueryParameters.processParameter(scanner.next(), parameters);
            }
        }
        return parameters;
    }

    private static void processParameter(String parameter, QueryParameters parameters) {
        String[] components = parameter.split("=");
        if (components.length > 0 && components.length < 3) {
            if (components.length == 2) {
                String name = components[0];
                String value = components[1];
                parameters.add(QueryParameters.decode(name), QueryParameters.decode(value));
            } else {
                List values = (List)parameters.computeIfAbsent(components[0], p -> new LinkedList());
                values.add("");
            }
        } else {
            throw new IllegalArgumentException("The parameter '" + parameter + "' is malformed");
        }
    }

    private static String decode(String encoded) {
        return URLDecoder.decode(encoded, StandardCharsets.UTF_8);
    }
}

