/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.springframework.restdocs.operation.preprocess.ContentModifyingOperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.DelegatingOperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.DelegatingOperationResponsePreprocessor;
import org.springframework.restdocs.operation.preprocess.HeadersModifyingOperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.LinkMaskingContentModifier;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.operation.preprocess.PatternReplacingContentModifier;
import org.springframework.restdocs.operation.preprocess.PrettyPrintingContentModifier;
import org.springframework.restdocs.operation.preprocess.UriModifyingOperationPreprocessor;

public final class Preprocessors {
    private Preprocessors() {
    }

    public static OperationRequestPreprocessor preprocessRequest(OperationPreprocessor ... preprocessors) {
        return new DelegatingOperationRequestPreprocessor(Arrays.asList(preprocessors));
    }

    public static OperationResponsePreprocessor preprocessResponse(OperationPreprocessor ... preprocessors) {
        return new DelegatingOperationResponsePreprocessor(Arrays.asList(preprocessors));
    }

    public static OperationPreprocessor prettyPrint() {
        return new ContentModifyingOperationPreprocessor(new PrettyPrintingContentModifier());
    }

    @Deprecated
    public static OperationPreprocessor removeHeaders(String ... headerNames) {
        HeadersModifyingOperationPreprocessor preprocessor = new HeadersModifyingOperationPreprocessor();
        for (String headerName : headerNames) {
            preprocessor.remove(headerName);
        }
        return preprocessor;
    }

    @Deprecated
    public static OperationPreprocessor removeMatchingHeaders(String ... headerNamePatterns) {
        HeadersModifyingOperationPreprocessor preprocessor = new HeadersModifyingOperationPreprocessor();
        for (String headerNamePattern : headerNamePatterns) {
            preprocessor.removeMatching(headerNamePattern);
        }
        return preprocessor;
    }

    public static OperationPreprocessor maskLinks() {
        return new ContentModifyingOperationPreprocessor(new LinkMaskingContentModifier());
    }

    public static OperationPreprocessor maskLinks(String mask) {
        return new ContentModifyingOperationPreprocessor(new LinkMaskingContentModifier(mask));
    }

    public static OperationPreprocessor replacePattern(Pattern pattern, String replacement) {
        return new ContentModifyingOperationPreprocessor(new PatternReplacingContentModifier(pattern, replacement));
    }

    public static HeadersModifyingOperationPreprocessor modifyHeaders() {
        return new HeadersModifyingOperationPreprocessor();
    }

    public static UriModifyingOperationPreprocessor modifyUris() {
        return new UriModifyingOperationPreprocessor();
    }
}

