/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;
import org.springframework.restdocs.snippet.ModelCreationException;
import org.springframework.restdocs.snippet.TemplatedSnippet;

public abstract class AbstractBodySnippet
extends TemplatedSnippet {
    private final PayloadSubsectionExtractor<?> subsectionExtractor;

    protected AbstractBodySnippet(String type, PayloadSubsectionExtractor<?> subsectionExtractor, Map<String, Object> attributes) {
        this(type, type, subsectionExtractor, attributes);
    }

    protected AbstractBodySnippet(String name, String type, PayloadSubsectionExtractor<?> subsectionExtractor, Map<String, Object> attributes) {
        super(name + "-body" + (String)(subsectionExtractor != null ? "-" + subsectionExtractor.getSubsectionId() : ""), type + "-body", attributes);
        this.subsectionExtractor = subsectionExtractor;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        try {
            Charset charset;
            MediaType contentType = this.getContentType(operation);
            String language = this.determineLanguage(contentType);
            byte[] content = this.getContent(operation);
            if (this.subsectionExtractor != null) {
                content = this.subsectionExtractor.extractSubsection(content, contentType);
            }
            String body = (charset = this.extractCharset(contentType)) != null ? new String(content, charset) : new String(content);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("language", language);
            model.put("body", body);
            return model;
        }
        catch (IOException ex) {
            throw new ModelCreationException(ex);
        }
    }

    private String determineLanguage(MediaType contentType) {
        if (contentType == null) {
            return null;
        }
        return contentType.getSubtypeSuffix() != null ? contentType.getSubtypeSuffix() : contentType.getSubtype();
    }

    private Charset extractCharset(MediaType contentType) {
        if (contentType == null) {
            return null;
        }
        return contentType.getCharset();
    }

    protected abstract byte[] getContent(Operation var1) throws IOException;

    protected abstract MediaType getContentType(Operation var1);
}

