/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ConstraintResolver;
import org.springframework.restdocs.constraints.ResourceBundleConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ValidatorConstraintResolver;

public class ConstraintDescriptions {
    private final Class<?> clazz;
    private final ConstraintResolver constraintResolver;
    private final ConstraintDescriptionResolver descriptionResolver;

    public ConstraintDescriptions(Class<?> clazz) {
        this(clazz, new ValidatorConstraintResolver(), new ResourceBundleConstraintDescriptionResolver());
    }

    public ConstraintDescriptions(Class<?> clazz, ConstraintResolver constraintResolver) {
        this(clazz, constraintResolver, new ResourceBundleConstraintDescriptionResolver());
    }

    public ConstraintDescriptions(Class<?> clazz, ConstraintDescriptionResolver descriptionResolver) {
        this(clazz, new ValidatorConstraintResolver(), descriptionResolver);
    }

    public ConstraintDescriptions(Class<?> clazz, ConstraintResolver constraintResolver, ConstraintDescriptionResolver descriptionResolver) {
        this.clazz = clazz;
        this.constraintResolver = constraintResolver;
        this.descriptionResolver = descriptionResolver;
    }

    public List<String> descriptionsForProperty(String property) {
        List<Constraint> constraints = this.constraintResolver.resolveForProperty(property, this.clazz);
        ArrayList<String> descriptions = new ArrayList<String>();
        for (Constraint constraint : constraints) {
            descriptions.add(this.descriptionResolver.resolveDescription(constraint));
        }
        Collections.sort(descriptions);
        return descriptions;
    }
}

