/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cookies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.restdocs.cookies.AbstractCookiesSnippet;
import org.springframework.restdocs.cookies.CookieDescriptor;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.ResponseCookie;
import org.springframework.restdocs.snippet.SnippetException;

public class ResponseCookiesSnippet
extends AbstractCookiesSnippet {
    protected ResponseCookiesSnippet(List<CookieDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected ResponseCookiesSnippet(List<CookieDescriptor> descriptors, boolean ignoreUndocumentedCookies) {
        this(descriptors, null, ignoreUndocumentedCookies);
    }

    protected ResponseCookiesSnippet(List<CookieDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected ResponseCookiesSnippet(List<CookieDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedCookies) {
        super("response", descriptors, attributes, ignoreUndocumentedCookies);
    }

    @Override
    protected Set<String> extractActualCookies(Operation operation) {
        return operation.getResponse().getCookies().stream().map(ResponseCookie::getName).collect(Collectors.toSet());
    }

    @Override
    protected void verificationFailed(Set<String> undocumentedCookies, Set<String> missingCookies) {
        Object message = "";
        if (!undocumentedCookies.isEmpty()) {
            message = (String)message + "Cookies with the following names were not documented: " + undocumentedCookies;
        }
        if (!missingCookies.isEmpty()) {
            if (((String)message).length() > 0) {
                message = (String)message + ". ";
            }
            message = (String)message + "Cookies with the following names were not found in the response: " + missingCookies;
        }
        throw new SnippetException((String)message);
    }

    public final ResponseCookiesSnippet and(CookieDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public final ResponseCookiesSnippet and(List<CookieDescriptor> additionalDescriptors) {
        ArrayList<CookieDescriptor> combinedDescriptors = new ArrayList<CookieDescriptor>(this.getCookieDescriptors().values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new ResponseCookiesSnippet(combinedDescriptors, this.getAttributes(), this.isIgnoreUndocumentedCookies());
    }
}

