/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.hypermedia.AbstractJsonLinkExtractor;
import org.springframework.restdocs.hypermedia.Link;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class AtomLinkExtractor
extends AbstractJsonLinkExtractor {
    AtomLinkExtractor() {
    }

    @Override
    public Map<String, List<Link>> extractLinks(Map<String, Object> json) {
        LinkedMultiValueMap extractedLinks = new LinkedMultiValueMap();
        Object possibleLinks = json.get("links");
        if (possibleLinks instanceof Collection) {
            Collection linksCollection = (Collection)possibleLinks;
            for (Object linkObject : linksCollection) {
                if (!(linkObject instanceof Map)) continue;
                Link link = AtomLinkExtractor.maybeCreateLink((Map)linkObject);
                AtomLinkExtractor.maybeStoreLink(link, (MultiValueMap<String, Link>)extractedLinks);
            }
        }
        return extractedLinks;
    }

    private static Link maybeCreateLink(Map<String, Object> linkMap) {
        Object hrefObject = linkMap.get("href");
        Object relObject = linkMap.get("rel");
        if (relObject instanceof String && hrefObject instanceof String) {
            Object titleObject = linkMap.get("title");
            return new Link((String)relObject, (String)hrefObject, titleObject instanceof String ? (String)titleObject : null);
        }
        return null;
    }

    private static void maybeStoreLink(Link link, MultiValueMap<String, Link> extractedLinks) {
        if (link != null) {
            extractedLinks.add((Object)link.getRel(), (Object)link);
        }
    }
}

