/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.hypermedia.AtomLinkExtractor;
import org.springframework.restdocs.hypermedia.HalLinkExtractor;
import org.springframework.restdocs.hypermedia.Link;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.operation.OperationResponse;

class ContentTypeLinkExtractor
implements LinkExtractor {
    private Map<MediaType, LinkExtractor> linkExtractors = new HashMap<MediaType, LinkExtractor>();

    ContentTypeLinkExtractor() {
        this.linkExtractors.put(MediaType.APPLICATION_JSON, new AtomLinkExtractor());
        this.linkExtractors.put(HalLinkExtractor.HAL_MEDIA_TYPE, new HalLinkExtractor());
    }

    ContentTypeLinkExtractor(Map<MediaType, LinkExtractor> linkExtractors) {
        this.linkExtractors.putAll(linkExtractors);
    }

    @Override
    public Map<String, List<Link>> extractLinks(OperationResponse response) throws IOException {
        MediaType contentType = response.getHeaders().getContentType();
        LinkExtractor extractorForContentType = this.getExtractorForContentType(contentType);
        if (extractorForContentType != null) {
            return extractorForContentType.extractLinks(response);
        }
        throw new IllegalStateException("No LinkExtractor has been provided and one is not available for the content type " + contentType);
    }

    private LinkExtractor getExtractorForContentType(MediaType contentType) {
        if (contentType != null) {
            for (Map.Entry<MediaType, LinkExtractor> entry : this.linkExtractors.entrySet()) {
                if (!contentType.isCompatibleWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

