/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.operation.HttpHeadersHelper;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.restdocs.operation.StandardOperationRequest;

public class OperationRequestFactory {
    public OperationRequest create(URI uri, HttpMethod method, byte[] content, HttpHeaders headers, Collection<OperationRequestPart> parts, Collection<RequestCookie> cookies) {
        return new StandardOperationRequest(uri, method, content, this.augmentHeaders(headers, uri, content), parts != null ? parts : Collections.emptyList(), cookies);
    }

    public OperationRequest create(URI uri, HttpMethod method, byte[] content, HttpHeaders headers, Collection<OperationRequestPart> parts) {
        return this.create(uri, method, content, headers, parts, Collections.emptyList());
    }

    public OperationRequest createFrom(OperationRequest original, byte[] newContent) {
        return new StandardOperationRequest(original.getUri(), original.getMethod(), newContent, this.getUpdatedHeaders(original.getHeaders(), newContent), original.getParts(), original.getCookies());
    }

    public OperationRequest createFrom(OperationRequest original, HttpHeaders newHeaders) {
        return new StandardOperationRequest(original.getUri(), original.getMethod(), original.getContent(), newHeaders, original.getParts(), original.getCookies());
    }

    private HttpHeaders augmentHeaders(HttpHeaders originalHeaders, URI uri, byte[] content) {
        return new HttpHeadersHelper(originalHeaders).addIfAbsent("Host", this.createHostHeader(uri)).setContentLengthHeader(content).getHeaders();
    }

    private String createHostHeader(URI uri) {
        if (uri.getPort() == -1) {
            return uri.getHost();
        }
        return uri.getHost() + ":" + uri.getPort();
    }

    private HttpHeaders getUpdatedHeaders(HttpHeaders originalHeaders, byte[] updatedContent) {
        return new HttpHeadersHelper(originalHeaders).updateContentLengthHeaderIfPresent(updatedContent).getHeaders();
    }
}

