/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.List;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.util.Assert;

class DelegatingOperationRequestPreprocessor
implements OperationRequestPreprocessor {
    private final List<OperationPreprocessor> delegates;

    DelegatingOperationRequestPreprocessor(List<OperationPreprocessor> delegates) {
        Assert.notNull(delegates, (String)"delegates must be non-null");
        this.delegates = delegates;
    }

    @Override
    public OperationRequest preprocess(OperationRequest operationRequest) {
        OperationRequest preprocessedRequest = operationRequest;
        for (OperationPreprocessor delegate : this.delegates) {
            preprocessedRequest = delegate.preprocess(preprocessedRequest);
        }
        return preprocessedRequest;
    }
}

