/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.restdocs.operation.preprocess.HeaderFilter;

class PatternMatchHeaderFilter
implements HeaderFilter {
    private Set<Pattern> exclusionPatterns = new HashSet<Pattern>();

    PatternMatchHeaderFilter(String ... exclusionPatterns) {
        for (String exclusionPattern : exclusionPatterns) {
            this.exclusionPatterns.add(Pattern.compile(exclusionPattern));
        }
    }

    @Override
    public boolean excludeHeader(String name) {
        for (Pattern pattern : this.exclusionPatterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

