/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.util.HashMap;
import java.util.Map;

public abstract class Attributes {
    private Attributes() {
    }

    public static AttributeBuilder key(String key) {
        return new AttributeBuilder(key);
    }

    public static Map<String, Object> attributes(Attribute ... attributes) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (Attribute attribute : attributes) {
            attributeMap.put(attribute.getKey(), attribute.getValue());
        }
        return attributeMap;
    }

    public static final class AttributeBuilder {
        private final String key;

        private AttributeBuilder(String key) {
            this.key = key;
        }

        public Attribute value(Object value) {
            return new Attribute(this.key, value);
        }
    }

    public static final class Attribute {
        private final String key;
        private final Object value;

        public Attribute(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

