/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cookies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.cookies.AbstractCookiesSnippet;
import org.springframework.restdocs.cookies.CookieDescriptor;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.restdocs.snippet.SnippetException;

public class RequestCookiesSnippet
extends AbstractCookiesSnippet {
    protected RequestCookiesSnippet(List<CookieDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected RequestCookiesSnippet(List<CookieDescriptor> descriptors, boolean ignoreUndocumentedCookies) {
        this(descriptors, null, ignoreUndocumentedCookies);
    }

    protected RequestCookiesSnippet(List<CookieDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected RequestCookiesSnippet(List<CookieDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedCookies) {
        super("request", descriptors, attributes, ignoreUndocumentedCookies);
    }

    @Override
    protected Set<String> extractActualCookies(Operation operation) {
        HashSet<String> actualCookies = new HashSet<String>();
        for (RequestCookie cookie : operation.getRequest().getCookies()) {
            actualCookies.add(cookie.getName());
        }
        return actualCookies;
    }

    @Override
    protected void verificationFailed(Set<String> undocumentedCookies, Set<String> missingCookies) {
        Object message = "";
        if (!undocumentedCookies.isEmpty()) {
            message = (String)message + "Cookies with the following names were not documented: " + undocumentedCookies;
        }
        if (!missingCookies.isEmpty()) {
            if (((String)message).length() > 0) {
                message = (String)message + ". ";
            }
            message = (String)message + "Cookies with the following names were not found in the request: " + missingCookies;
        }
        throw new SnippetException((String)message);
    }

    public final RequestCookiesSnippet and(CookieDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public final RequestCookiesSnippet and(List<CookieDescriptor> additionalDescriptors) {
        ArrayList<CookieDescriptor> combinedDescriptors = new ArrayList<CookieDescriptor>(this.getCookieDescriptors().values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new RequestCookiesSnippet(combinedDescriptors, this.getAttributes(), this.isIgnoreUndocumentedCookies());
    }
}

