/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.operation.AbstractOperationMessage;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.RequestCookie;

class StandardOperationRequest
extends AbstractOperationMessage
implements OperationRequest {
    private HttpMethod method;
    private Collection<OperationRequestPart> parts;
    private URI uri;
    private Collection<RequestCookie> cookies;

    StandardOperationRequest(URI uri, HttpMethod method, byte[] content, HttpHeaders headers, Collection<OperationRequestPart> parts, Collection<RequestCookie> cookies) {
        super(content, headers);
        this.uri = uri;
        this.method = method;
        this.parts = parts;
        this.cookies = cookies;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public Collection<OperationRequestPart> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Collection<RequestCookie> getCookies() {
        return this.cookies;
    }
}

